import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import _toConsumableArray from "@babel/runtime/helpers/toConsumableArray";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useMemo, memo } from 'react';
import { useEuiMemoizedStyles } from '../../services';
import { EuiI18n } from '../i18n';
import { EuiPopoverFooter } from '../popover';
import { EuiButtonEmpty } from '../button';
import { EuiFlexGroup, EuiFlexItem } from '../flex';
import { EuiTourStepIndicator } from './tour_step_indicator';
import { euiTourFooterStyles } from './_tour_footer.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiTourFooter = /*#__PURE__*/memo(function (_ref) {
  var footerAction = _ref.footerAction,
    step = _ref.step,
    stepsTotal = _ref.stepsTotal,
    onFinish = _ref.onFinish;
  var footerStyles = useEuiMemoizedStyles(euiTourFooterStyles);
  var customFooterAction = useMemo(function () {
    if (!footerAction) return null;
    return Array.isArray(footerAction) ? ___EmotionJSX(EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "center",
      justifyContent: "flexEnd",
      responsive: false,
      wrap: true
    }, footerAction.map(function (action, index) {
      return ___EmotionJSX(EuiFlexItem, {
        key: index,
        grow: false
      }, action);
    })) : ___EmotionJSX(EuiFlexItem, {
      grow: false
    }, footerAction);
  }, [footerAction]);
  var indicators = useMemo(function () {
    if (stepsTotal <= 1) return null;
    return ___EmotionJSX(EuiFlexItem, {
      grow: false
    }, ___EmotionJSX("ul", {
      className: "euiTourFooter__stepList"
    }, _toConsumableArray(Array(stepsTotal).keys()).map(function (_, i) {
      var status = 'complete';
      if (step === i + 1) {
        status = 'active';
      } else if (step <= i) {
        status = 'incomplete';
      }
      return ___EmotionJSX(EuiTourStepIndicator, {
        key: i,
        number: i + 1,
        status: status
      });
    })));
  }, [step, stepsTotal]);
  return ___EmotionJSX(EuiPopoverFooter, {
    css: footerStyles.euiTourFooter,
    className: "euiTourFooter"
  }, ___EmotionJSX(EuiFlexGroup, {
    responsive: false,
    justifyContent: stepsTotal > 1 ? 'spaceBetween' : 'flexEnd',
    alignItems: "center"
  }, indicators, footerAction ? customFooterAction : ___EmotionJSX(EuiFlexItem, {
    grow: false
  }, ___EmotionJSX(EuiI18n, {
    tokens: ['euiTourFooter.endTour', 'euiTourFooter.skipTour', 'euiTourFooter.closeTour'],
    defaults: ['End tour', 'Skip tour', 'Close tour']
  }, function (_ref2) {
    var _ref3 = _slicedToArray(_ref2, 3),
      endTour = _ref3[0],
      skipTour = _ref3[1],
      closeTour = _ref3[2];
    return ___EmotionJSX(EuiButtonEmpty, {
      onClick: onFinish,
      color: "text",
      flush: "right",
      size: "xs"
    }, stepsTotal > 1 ? stepsTotal === step ? endTour : skipTour : closeTour);
  }))));
});
EuiTourFooter.displayName = '_EuiTourFooter';