/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { logicalCSS } from '../../global_styling';
export var euiTourHeaderStyles = function euiTourHeaderStyles(_ref) {
  var euiTheme = _ref.euiTheme;
  return {
    // Base
    euiTourHeader: /*#__PURE__*/css(logicalCSS('border-bottom', 'none'), logicalCSS('margin-bottom', euiTheme.size.s), ";;label:euiTourHeader;"),
    // Elements
    euiTourHeader__title: /*#__PURE__*/css(logicalCSS('margin-top', 0), ";;label:euiTourHeader__title;"),
    euiTourHeader__subtitle: /*#__PURE__*/css("color:", euiTheme.colors.subduedText, ";padding-block-end:", euiTheme.size.xs, ";;label:euiTourHeader__subtitle;")
  };
};