/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { logicalCSS, mathWithUnits, euiCanAnimate } from '../../global_styling';
import { openAnimationTiming } from '../popover/popover_panel/_popover_panel.styles';
import { popoverArrowSize } from '../popover/popover_arrow/_popover_arrow.styles';
import { _tourFooterBgColor } from './_tour_footer.styles';
export var euiTourStyles = function euiTourStyles(euiThemeContext) {
  return {
    // Targets EuiPopoverPanel
    euiTour: /*#__PURE__*/css("[data-popover-arrow='top']::before{", logicalCSS('border-top-color', _tourFooterBgColor(euiThemeContext)), ";};label:euiTour;")
  };
};
export var euiTourBeaconStyles = function euiTourBeaconStyles(_ref) {
  var euiTheme = _ref.euiTheme;
  var arrowSize = euiTheme.size[popoverArrowSize];
  var arrowHalfSize = mathWithUnits(arrowSize, function (x) {
    return x / 2;
  });
  var arrowOffset = mathWithUnits(arrowSize, function (x) {
    return x * -2;
  });
  return {
    // Base
    euiTourBeacon: /*#__PURE__*/css("pointer-events:none;position:absolute;", euiCanAnimate, "{opacity:0;transition:opacity 0s ", euiTheme.animation[openAnimationTiming], ";};label:euiTourBeacon;"),
    isOpen: /*#__PURE__*/css(euiCanAnimate, "{opacity:1;};label:isOpen;"),
    // Positions
    right: /*#__PURE__*/css(logicalCSS('top', arrowHalfSize), " ", logicalCSS('left', arrowOffset), ";;label:right;"),
    left: /*#__PURE__*/css(logicalCSS('top', arrowHalfSize), " ", logicalCSS('left', arrowSize), ";;label:left;"),
    top: /*#__PURE__*/css(logicalCSS('top', arrowSize), " ", logicalCSS('left', arrowHalfSize), ";;label:top;"),
    bottom: /*#__PURE__*/css(logicalCSS('top', arrowOffset), " ", logicalCSS('left', arrowHalfSize), ";;label:bottom;")
  };
};