import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["anchorPosition", "anchor", "children", "className", "css", "closePopover", "content", "isStepOpen", "minWidth", "maxWidth", "onFinish", "step", "stepsTotal", "subtitle", "title", "decoration", "footerAction", "panelProps", "panelClassName"];
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useEffect, useState, useMemo, useCallback } from 'react';
import classNames from 'classnames';
import { useGeneratedHtmlId, findElementBySelectorOrRef, useEuiMemoizedStyles } from '../../services';
import { logicalStyles } from '../../global_styling';
import { EuiPopover, EuiWrappingPopover } from '../popover';
import { EuiBeacon } from '../beacon';
import { EuiTourHeader } from './_tour_header';
import { EuiTourFooter } from './_tour_footer';
import { euiTourStyles, euiTourBeaconStyles } from './tour.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiTourStep = function EuiTourStep(_ref) {
  var _ref$anchorPosition = _ref.anchorPosition,
    anchorPosition = _ref$anchorPosition === void 0 ? 'leftUp' : _ref$anchorPosition,
    anchor = _ref.anchor,
    children = _ref.children,
    className = _ref.className,
    css = _ref.css,
    _ref$closePopover = _ref.closePopover,
    closePopover = _ref$closePopover === void 0 ? function () {} : _ref$closePopover,
    content = _ref.content,
    _ref$isStepOpen = _ref.isStepOpen,
    isStepOpen = _ref$isStepOpen === void 0 ? false : _ref$isStepOpen,
    _ref$minWidth = _ref.minWidth,
    minWidth = _ref$minWidth === void 0 ? 300 : _ref$minWidth,
    _ref$maxWidth = _ref.maxWidth,
    maxWidth = _ref$maxWidth === void 0 ? 600 : _ref$maxWidth,
    onFinish = _ref.onFinish,
    _ref$step = _ref.step,
    step = _ref$step === void 0 ? 1 : _ref$step,
    stepsTotal = _ref.stepsTotal,
    subtitle = _ref.subtitle,
    title = _ref.title,
    _ref$decoration = _ref.decoration,
    decoration = _ref$decoration === void 0 ? 'beacon' : _ref$decoration,
    footerAction = _ref.footerAction,
    panelProps = _ref.panelProps,
    panelClassName = _ref.panelClassName,
    rest = _objectWithoutProperties(_ref, _excluded);
  var titleId = useGeneratedHtmlId();
  if (step === 0) {
    console.warn('EuiTourStep `step` should use 1-based indexing. Please update to eliminate 0 indexes.');
  }
  var _useState = useState(null),
    _useState2 = _slicedToArray(_useState, 2),
    anchorNode = _useState2[0],
    setAnchorNode = _useState2[1];
  var _useState3 = useState(),
    _useState4 = _slicedToArray(_useState3, 2),
    popoverPosition = _useState4[0],
    setPopoverPosition = _useState4[1];
  var onPositionChange = useCallback(function (position) {
    setPopoverPosition(position);
  }, []);
  useEffect(function () {
    if (anchor) {
      // Wait until next tick to find anchor node in case it's not already
      // in DOM requestAnimationFrame isn't used here because we don't need to
      // synchronize with repainting ticks and the updated value still
      // needs to go through a react DOM rerender which may take more than
      // 1 frame (16ms) of time.
      // TODO: It would be ideal to have some kind of intersection observer here instead
      var timeout = window.setTimeout(function () {
        setAnchorNode(findElementBySelectorOrRef(anchor));
      });
      return function () {
        return window.clearTimeout(timeout);
      };
    }
  }, [anchor]);
  var anchorClasses = classNames('euiTourAnchor', className);
  var popoverClasses = classNames('euiTour', panelClassName);
  var tourStyles = useEuiMemoizedStyles(euiTourStyles);
  var beaconStyles = useEuiMemoizedStyles(euiTourBeaconStyles);
  var beaconCss = [beaconStyles.euiTourBeacon, isStepOpen && beaconStyles.isOpen, popoverPosition && beaconStyles[popoverPosition]];
  var hasBeacon = decoration === 'beacon';
  var widthStyles = useMemo(function () {
    return logicalStyles({
      minWidth: minWidth,
      maxWidth: maxWidth
    });
  }, [minWidth, maxWidth]);
  var noAnchor = !anchor && children;
  var PopoverComponent = noAnchor ? EuiPopover : EuiWrappingPopover;
  var button = noAnchor ? children : anchorNode;
  return button ? ___EmotionJSX(PopoverComponent, _extends({
    button: button,
    className: anchorClasses,
    anchorPosition: anchorPosition,
    closePopover: closePopover,
    isOpen: isStepOpen,
    ownFocus: false,
    panelClassName: popoverClasses,
    panelProps: _objectSpread(_objectSpread({}, panelProps), {}, {
      css: [tourStyles.euiTour, css, panelProps === null || panelProps === void 0 ? void 0 : panelProps.css]
    }),
    offset: hasBeacon ? 10 : 0,
    "aria-labelledby": titleId,
    arrowChildren: hasBeacon && ___EmotionJSX(EuiBeacon, {
      css: beaconCss,
      className: "euiTour__beacon"
    }),
    onPositionChange: onPositionChange
  }, rest), ___EmotionJSX("div", {
    style: widthStyles
  }, ___EmotionJSX(EuiTourHeader, {
    id: titleId,
    title: title,
    subtitle: subtitle
  }), ___EmotionJSX("div", {
    className: "euiTour__content"
  }, content), ___EmotionJSX(EuiTourFooter, {
    footerAction: footerAction,
    step: step,
    stepsTotal: stepsTotal,
    onFinish: onFinish
  }))) : null;
};