import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["className", "number", "status"];
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React from 'react';
import classNames from 'classnames';
import { css } from '@emotion/react';
import { EuiIcon } from '../icon';
import { EuiI18n } from '../i18n';
import { jsx as ___EmotionJSX } from "@emotion/react";
var _ref = process.env.NODE_ENV === "production" ? {
  name: "1v4nm53-EuiTourStepIndicator",
  styles: "display:inline-block;label:EuiTourStepIndicator;"
} : {
  name: "1v4nm53-EuiTourStepIndicator",
  styles: "display:inline-block;label:EuiTourStepIndicator;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
export var EuiTourStepIndicator = function EuiTourStepIndicator(_ref2) {
  var className = _ref2.className,
    number = _ref2.number,
    status = _ref2.status,
    rest = _objectWithoutProperties(_ref2, _excluded);
  var classes = classNames('euiTourStepIndicator', className);
  var indicatorIcon;
  if (status === 'active') {
    indicatorIcon = ___EmotionJSX(EuiI18n, {
      token: "euiTourStepIndicator.isActive",
      default: "active"
    }, function (isActive) {
      return ___EmotionJSX(EuiIcon, {
        type: "dot",
        "aria-label": isActive,
        color: "success",
        "aria-current": "step"
      });
    });
  } else if (status === 'complete') {
    indicatorIcon = ___EmotionJSX(EuiI18n, {
      token: "euiTourStepIndicator.isComplete",
      default: "complete"
    }, function (isComplete) {
      return ___EmotionJSX(EuiIcon, {
        type: "dot",
        "aria-label": isComplete,
        color: "subdued"
      });
    });
  } else if (status === 'incomplete') {
    indicatorIcon = ___EmotionJSX(EuiI18n, {
      token: "euiTourStepIndicator.isIncomplete",
      default: "incomplete"
    }, function (isIncomplete) {
      return ___EmotionJSX(EuiIcon, {
        type: "dot",
        "aria-label": isIncomplete,
        color: "subdued"
      });
    });
  }
  return ___EmotionJSX(EuiI18n, {
    token: "euiTourStepIndicator.ariaLabel",
    default: "Step {number} {status}",
    values: {
      status: status,
      number: number
    }
  }, function (ariaLabel) {
    return ___EmotionJSX("li", _extends({
      css: _ref,
      className: classes,
      "aria-label": ariaLabel
    }, rest), indicatorIcon);
  });
};