import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import _toConsumableArray from "@babel/runtime/helpers/toConsumableArray";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";
import _inherits from "@babel/runtime/helpers/inherits";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
var _excluded = ["children", "className", "items", "display", "expandByDefault", "showExpansionArrows", "theme"];
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { Component, createContext } from 'react';
import classNames from 'classnames';
import { withEuiTheme, keys, htmlIdGenerator } from '../../services';
import { EuiI18n } from '../i18n';
import { EuiScreenReaderOnly } from '../accessibility';
import { EuiTreeViewItem } from './tree_view_item';
import { euiTreeViewStyles } from './tree_view.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
var EuiTreeViewContext = /*#__PURE__*/createContext('');
function getTreeId(propId) {
  var contextId = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';
  var idGenerator = arguments.length > 2 ? arguments[2] : undefined;
  return propId !== null && propId !== void 0 ? propId : contextId === '' ? idGenerator() : contextId;
}
export var EuiTreeViewClass = /*#__PURE__*/function (_Component) {
  function EuiTreeViewClass(props,
  // Without the optional ? typing, TS will throw errors on JSX component errors
  // @see https://github.com/facebook/react/issues/13944#issuecomment-1183693239
  context) {
    var _this;
    _classCallCheck(this, EuiTreeViewClass);
    // TODO: context in constructor has been deprecated.
    // We should likely convert this to a function component
    _this = _callSuper(this, EuiTreeViewClass, [props, context]);
    _defineProperty(_this, "treeIdGenerator", htmlIdGenerator('euiTreeView'));
    _defineProperty(_this, "isNested", void 0);
    _defineProperty(_this, "buttonRef", []);
    _defineProperty(_this, "setButtonRef", function (ref, index) {
      _this.buttonRef[index] = ref;
    });
    _defineProperty(_this, "handleNodeClick", function (node) {
      var ignoreCallback = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
      var index = _this.state.openItems.indexOf(node.id);
      _this.setState({
        expandChildNodes: false
      });
      node.isExpanded = !node.isExpanded;
      if (!ignoreCallback && node.callback !== undefined) {
        node.callback();
      }
      if (_this.isNodeOpen(node)) {
        // if the node is part of openItems[] then remove it
        _this.setState({
          openItems: _this.state.openItems.filter(function (_, i) {
            return i !== index;
          })
        });
      } else {
        // if the node isn't part of openItems[] then add it
        _this.setState(function (prevState) {
          return {
            openItems: [].concat(_toConsumableArray(prevState.openItems), [node.id]),
            activeItem: node.id
          };
        });
      }
    });
    // check if the node is included in openItems[]
    _defineProperty(_this, "isNodeOpen", function (node) {
      return _this.state.openItems.includes(node.id);
    });
    // Enable keyboard navigation
    _defineProperty(_this, "onKeyDown", function (event, node) {
      switch (event.key) {
        case keys.ARROW_DOWN:
          {
            var nodeButtons = Array.from(document.querySelectorAll("[data-test-subj=\"euiTreeViewButton-".concat(_this.state.treeID, "\"]")));
            var currentIndex = nodeButtons.indexOf(event.currentTarget);
            if (currentIndex > -1) {
              var nextButton = nodeButtons[currentIndex + 1];
              if (nextButton) {
                event.preventDefault();
                event.stopPropagation();
                nextButton.focus();
              }
            }
            break;
          }
        case keys.ARROW_UP:
          {
            var _nodeButtons = Array.from(document.querySelectorAll("[data-test-subj=\"euiTreeViewButton-".concat(_this.state.treeID, "\"]")));
            var _currentIndex = _nodeButtons.indexOf(event.currentTarget);
            if (_currentIndex > -1) {
              var prevButton = _nodeButtons[_currentIndex + -1];
              if (prevButton) {
                event.preventDefault();
                event.stopPropagation();
                prevButton.focus();
              }
            }
            break;
          }
        case keys.ARROW_RIGHT:
          {
            if (!_this.isNodeOpen(node)) {
              event.preventDefault();
              event.stopPropagation();
              _this.handleNodeClick(node, true);
            }
            break;
          }
        case keys.ARROW_LEFT:
          {
            if (_this.isNodeOpen(node)) {
              event.preventDefault();
              event.stopPropagation();
              _this.handleNodeClick(node, true);
            }
          }
        default:
          break;
      }
    });
    _defineProperty(_this, "onChildrenKeydown", function (event, index) {
      if (event.key === keys.ARROW_LEFT) {
        event.preventDefault();
        event.stopPropagation();
        _this.buttonRef[index].focus();
      }
    });
    _this.isNested = !!_this.context;
    _this.state = {
      openItems: _this.props.expandByDefault ? _this.props.items.map(function (_ref) {
        var id = _ref.id,
          children = _ref.children;
        return children ? id : null;
      }).filter(function (x) {
        return x != null;
      }) : _this.props.items.map(function (_ref2) {
        var id = _ref2.id,
          children = _ref2.children,
          isExpanded = _ref2.isExpanded;
        return children && isExpanded ? id : null;
      }).filter(function (x) {
        return x != null;
      }),
      activeItem: '',
      treeID: getTreeId(_this.props.id, context, _this.treeIdGenerator),
      expandChildNodes: _this.props.expandByDefault || false
    };
    return _this;
  }
  _inherits(EuiTreeViewClass, _Component);
  return _createClass(EuiTreeViewClass, [{
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      if (this.props.id !== prevProps.id) {
        this.setState({
          treeID: getTreeId(this.props.id, this.context, this.treeIdGenerator)
        });
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;
      var _this$props = this.props,
        children = _this$props.children,
        className = _this$props.className,
        items = _this$props.items,
        _this$props$display = _this$props.display,
        display = _this$props$display === void 0 ? 'default' : _this$props$display,
        expandByDefault = _this$props.expandByDefault,
        showExpansionArrows = _this$props.showExpansionArrows,
        theme = _this$props.theme,
        rest = _objectWithoutProperties(_this$props, _excluded);
      var styles = euiTreeViewStyles(theme);
      var cssStyles = [styles.euiTreeView, styles[display]];

      // Computed classNames
      var classes = classNames('euiTreeView', className);
      var instructionsId = "".concat(this.state.treeID, "--instruction");
      return ___EmotionJSX(EuiTreeViewContext.Provider, {
        value: this.state.treeID
      }, !this.isNested && ___EmotionJSX(EuiI18n, {
        token: "euiTreeView.listNavigationInstructions",
        default: "You can quickly navigate this list using arrow keys."
      }, function (listNavigationInstructions) {
        return ___EmotionJSX(EuiScreenReaderOnly, null, ___EmotionJSX("p", {
          id: instructionsId
        }, listNavigationInstructions));
      }), ___EmotionJSX("ul", _extends({
        css: cssStyles,
        className: classes,
        id: !this.isNested ? this.state.treeID : undefined,
        "aria-describedby": !this.isNested ? instructionsId : undefined,
        role: "list" // VoiceOver doesn't parse lists with `list-style: none` as the correct role - @see https://www.scottohara.me/blog/2019/01/12/lists-and-safari.html
      }, rest), items.map(function (node, index) {
        var buttonId = node.id;
        var wrappingId = _this2.treeIdGenerator(buttonId);
        var isNodeExpanded = node.children ? _this2.isNodeOpen(node) : undefined; // Determines the `aria-expanded` attribute

        var icon = node.icon;
        if (node.iconWhenExpanded && isNodeExpanded) {
          icon = node.iconWhenExpanded;
        } else if (!icon && node.useEmptyIcon) {
          icon = ___EmotionJSX(React.Fragment, null); // Renders a placeholder
        }
        return ___EmotionJSX(EuiTreeViewItem, {
          key: buttonId + index,
          id: buttonId,
          className: node.className,
          buttonRef: function buttonRef(ref) {
            return _this2.setButtonRef(ref, index);
          },
          "aria-controls": node.children ? wrappingId : undefined,
          label: node.label,
          icon: icon,
          hasArrow: showExpansionArrows,
          isExpanded: isNodeExpanded,
          isActive: _this2.state.activeItem === node.id,
          display: display,
          "data-test-subj": "euiTreeViewButton-".concat(_this2.state.treeID),
          onKeyDown: function onKeyDown(event) {
            return _this2.onKeyDown(event, node);
          },
          onClick: function onClick() {
            return _this2.handleNodeClick(node);
          }
        }, node.children && ___EmotionJSX("div", {
          id: wrappingId,
          onKeyDown: function onKeyDown(event) {
            return _this2.onChildrenKeydown(event, index);
          }
        }, isNodeExpanded && ___EmotionJSX(EuiTreeView, {
          items: node.children,
          display: display,
          showExpansionArrows: showExpansionArrows,
          expandByDefault: _this2.state.expandChildNodes
        })));
      })));
    }
  }]);
}(Component);
_defineProperty(EuiTreeViewClass, "contextType", EuiTreeViewContext);
export var EuiTreeView = Object.assign(withEuiTheme(EuiTreeViewClass), {
  Item: EuiTreeViewItem
});