import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["id", "label", "className", "children", "display", "icon", "hasArrow", "isActive", "isExpanded", "buttonRef", "wrapperProps"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { memo } from 'react';
import classNames from 'classnames';
import { useEuiMemoizedStyles } from '../../services';
import { EuiIcon } from '../icon';
import { euiTreeViewItemStyles } from './tree_view_item.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiTreeViewItem = /*#__PURE__*/memo(function (_ref) {
  var id = _ref.id,
    label = _ref.label,
    className = _ref.className,
    children = _ref.children,
    _ref$display = _ref.display,
    display = _ref$display === void 0 ? 'default' : _ref$display,
    icon = _ref.icon,
    hasArrow = _ref.hasArrow,
    isActive = _ref.isActive,
    isExpanded = _ref.isExpanded,
    buttonRef = _ref.buttonRef,
    wrapperProps = _ref.wrapperProps,
    rest = _objectWithoutProperties(_ref, _excluded);
  var styles = useEuiMemoizedStyles(euiTreeViewItemStyles);
  var wrapperClasses = classNames('euiTreeView__node', {
    'euiTreeView__node--expanded': isExpanded
  }, wrapperProps === null || wrapperProps === void 0 ? void 0 : wrapperProps.className);
  var wrapperStyles = [styles.li.euiTreeView__node, styles.li[display], isExpanded && styles.li.expanded];
  var buttonClasses = classNames('euiTreeView__nodeInner', className, {
    'euiTreeView__node--active': isActive
  });
  var buttonStyles = [styles.button.euiTreeView__nodeInner, styles.button[display]];
  var iconStyles = [styles.icon.euiTreeView__iconWrapper, styles.icon[display]];
  return ___EmotionJSX("li", _extends({}, wrapperProps, {
    css: wrapperStyles,
    className: wrapperClasses
  }), ___EmotionJSX("button", _extends({
    id: id,
    css: buttonStyles,
    className: buttonClasses,
    "aria-expanded": isExpanded,
    ref: buttonRef
  }, rest), hasArrow && (!!children ? ___EmotionJSX(EuiIcon, {
    className: "euiTreeView__expansionArrow",
    size: display === 'compressed' ? 's' : 'm',
    type: isExpanded ? 'arrowDown' : 'arrowRight'
  }) : ___EmotionJSX("span", {
    css: iconStyles,
    className: "euiTreeView__arrowPlaceholder"
  })), icon && ___EmotionJSX("span", {
    css: iconStyles,
    className: "euiTreeView__iconWrapper"
  }, icon), ___EmotionJSX("span", {
    className: "euiTreeView__nodeLabel eui-textTruncate"
  }, label)), children);
});
EuiTreeViewItem.displayName = 'EuiTreeViewItem';