import _defineProperty from "@babel/runtime/helpers/defineProperty";
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { shade, tint, tintOrShade, transparentize, useEuiMemoizedStyles } from '../../services';
export var BACKGROUND_COLORS = ['transparent', 'plain', 'subdued', 'accent', 'primary', 'success', 'warning', 'danger'];
/**
 * @returns A single background color with optional alpha transparency
 */
export var euiBackgroundColor = function euiBackgroundColor(_ref, color) {
  var euiTheme = _ref.euiTheme,
    colorMode = _ref.colorMode;
  var _ref2 = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {},
    method = _ref2.method;
  if (color === 'transparent') return 'transparent';
  if (method === 'transparent') {
    if (color === 'plain') {
      return transparentize(euiTheme.colors.ghost, 0.2);
    } else if (color === 'subdued') {
      return colorMode === 'DARK' ? transparentize(euiTheme.colors.lightShade, 0.4) : transparentize(euiTheme.colors.lightShade, 0.2);
    } else {
      return transparentize(euiTheme.colors[color], 0.1);
    }
  } else {
    var _tintOrShade = function _tintOrShade(color) {
      return colorMode === 'DARK' ? shade(color, 0.8) : tint(color, 0.9);
    };
    switch (color) {
      case 'plain':
        return euiTheme.colors.emptyShade;
      case 'subdued':
        return euiTheme.colors.body;
      default:
        return _tintOrShade(euiTheme.colors[color]);
    }
  }
};

/**
 * @returns An object map of color keys to color values, categorized by
 * opaque (default) vs transparency (hover/focus states) methods.
 * e.g. {
 *  opaque: { danger: '#000', success: '#fff', ... },
 *  transparent: { danger: 'rgba(0,0,0,0.1)', success: 'rgba(255,255,255,0.1)', ... },
 * }
 */
var _euiBackgroundColorMap = function _euiBackgroundColorMap(euiThemeContext) {
  return {
    opaque: BACKGROUND_COLORS.reduce(function (acc, color) {
      return _objectSpread(_objectSpread({}, acc), {}, _defineProperty({}, color, euiBackgroundColor(euiThemeContext, color)));
    }, {}),
    transparent: BACKGROUND_COLORS.reduce(function (acc, color) {
      return _objectSpread(_objectSpread({}, acc), {}, _defineProperty({}, color, euiBackgroundColor(euiThemeContext, color, {
        method: 'transparent'
      })));
    }, {})
  };
};
export var useEuiBackgroundColor = function useEuiBackgroundColor(color) {
  var _ref3 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
    method = _ref3.method;
  var backgroundColorMap = useEuiMemoizedStyles(_euiBackgroundColorMap);
  return backgroundColorMap[method || 'opaque'][color];
};

/**
 * @returns An object map of color keys to CSS,
 * e.g. { danger: css``, success: css``, ... }
 */
var _euiBackgroundColors = function _euiBackgroundColors(euiThemeContext) {
  return BACKGROUND_COLORS.reduce(function (acc, color) {
    return _objectSpread(_objectSpread({}, acc), {}, _defineProperty({}, color, /*#__PURE__*/css("background-color:", euiBackgroundColor(euiThemeContext, color), ";label:", color, ";")));
  }, {});
};
export var useEuiBackgroundColorCSS = function useEuiBackgroundColorCSS() {
  return useEuiMemoizedStyles(_euiBackgroundColors);
};

/**
 * Border colors
 */

export var euiBorderColor = function euiBorderColor(_ref4, color) {
  var euiTheme = _ref4.euiTheme,
    colorMode = _ref4.colorMode;
  switch (color) {
    case 'transparent':
    case 'plain':
    case 'subdued':
      return euiTheme.border.color;
    case 'warning':
      return tintOrShade(euiTheme.colors.warning, 0.4, colorMode);
    default:
      return tintOrShade(euiTheme.colors[color], 0.6, colorMode);
  }
};

/**
 * @returns An object map of color keys to CSS,
 * e.g. { danger: css``, success: css``, ... }
 */
var _euiBorderColors = function _euiBorderColors(euiThemeContext) {
  return BACKGROUND_COLORS.reduce(function (acc, color) {
    return _objectSpread(_objectSpread({}, acc), {}, _defineProperty({}, color, /*#__PURE__*/css("border-color:", euiBorderColor(euiThemeContext, color), ";label:", color, ";")));
  }, {});
};
export var useEuiBorderColorCSS = function useEuiBorderColorCSS() {
  return useEuiMemoizedStyles(_euiBorderColors);
};