import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { useEuiMemoizedStyles } from '../../services/theme';
export var PADDING_SIZES = ['none', 'xs', 's', 'm', 'l', 'xl'];
/**
 * Get a single padding size
 */

export var euiPaddingSize = function euiPaddingSize(_ref, size) {
  var euiTheme = _ref.euiTheme;
  switch (size) {
    case 'none':
      return null;
    case 'm':
      return euiTheme.size.base;
    default:
      return euiTheme.size[size];
  }
};

/**
 * @returns An object map of padding size keys to padding values,
 * e.g. { s: '8px', m: '16px', ... }
 */
var _getEuiPaddingSize = function _getEuiPaddingSize(euiThemeContext) {
  return PADDING_SIZES.reduce(function (stylesAcc, size) {
    return _objectSpread(_objectSpread({}, stylesAcc), {}, _defineProperty({}, size, size === 'none' ? null : euiPaddingSize(euiThemeContext, size)));
  }, {});
};
export var useEuiPaddingSize = function useEuiPaddingSize(size) {
  var sizes = useEuiMemoizedStyles(_getEuiPaddingSize);
  return sizes[size];
};

/**
 * @returns An object map of all padding sizes for all padding sides properties
 * e.g., {
 *   padding: { s: css`padding-size: 8px`, ... }
 *   left: { s: css`padding-inline-start: 8px`, ... }
 * }
 */
var _euiPaddingSidesAndSizes = function _euiPaddingSidesAndSizes(euiThemeContext) {
  var sizesMap = _getEuiPaddingSize(euiThemeContext);
  // The `_` prefix stops Emotion from applying the function name as a label
  var _generateSizeStyles = function _generateSizeStyles(cssProperty) {
    return Object.fromEntries(Object.entries(sizesMap).map(function (_ref2) {
      var _ref3 = _slicedToArray(_ref2, 2),
        sizeKey = _ref3[0],
        sizeValue = _ref3[1];
      return [sizeKey, sizeValue === null ? null : /*#__PURE__*/css(cssProperty, ":", sizeValue, ";label:", sizeKey, ";")];
    }));
  };
  var sidesMap = {
    padding: _generateSizeStyles('padding'),
    vertical: _generateSizeStyles('padding-block'),
    top: _generateSizeStyles('padding-block-start'),
    bottom: _generateSizeStyles('padding-block-end'),
    horizontal: _generateSizeStyles('padding-inline'),
    left: _generateSizeStyles('padding-inline-start'),
    right: _generateSizeStyles('padding-inline-end')
  };
  return sidesMap;
};
export var useEuiPaddingCSS = function useEuiPaddingCSS(side) {
  var memoizedSideMap = useEuiMemoizedStyles(_euiPaddingSidesAndSizes);
  return memoizedSideMap[side || 'padding'];
};