/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React from 'react';
import { Global, css } from '@emotion/react';
import { useEuiTheme } from '../../services/theme/hooks';
import { euiScreenReaderOnly } from '../../components/accessibility/screen_reader_only/screen_reader_only.styles';
import { euiFullHeight, euiTextBreakWord, euiTextTruncate, euiNumberFormat, euiScrollBarStyles, euiYScroll, euiXScroll, euiYScrollWithShadows, euiXScrollWithShadows, euiBreakpoint } from '../mixins';
import { logicalCSS } from '../functions';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var globalStyles = function globalStyles(euiThemeContext) {
  return /*#__PURE__*/css(".euiScreenReaderOnly{", euiScreenReaderOnly(), ";}.eui-alignBaseline{vertical-align:baseline!important;}.eui-alignBottom{vertical-align:bottom!important;}.eui-alignMiddle{vertical-align:middle!important;}.eui-alignTop{vertical-align:top!important;}.eui-displayBlock{display:block!important;}.eui-displayInline{display:inline!important;}.eui-displayInlineBlock{display:inline-block!important;}.eui-fullWidth{display:block!important;", logicalCSS('width', '100% !important'), ";}.eui-fullHeight{", euiFullHeight(), ";}.eui-textCenter{text-align:center!important;}.eui-textLeft{text-align:start!important;}.eui-textRight{text-align:end!important;}.eui-textNoWrap{white-space:nowrap!important;}.eui-textInheritColor{color:inherit!important;}.eui-textBreakWord{", euiTextBreakWord(), ";}.eui-textBreakAll{overflow-wrap:break-word!important;word-break:break-all!important;}.eui-textBreakNormal{overflow-wrap:normal!important;word-wrap:normal!important;word-break:normal!important;}.eui-textTruncate{", euiTextTruncate(), ";}.eui-textNumber{", euiNumberFormat(euiThemeContext), ";}.eui-scrollBar{", euiScrollBarStyles(euiThemeContext), ";}.eui-yScroll{", euiYScroll(euiThemeContext), ";}.eui-xScroll{", euiXScroll(euiThemeContext), ";}.eui-yScrollWithShadows{", euiYScrollWithShadows(euiThemeContext), ";}.eui-xScrollWithShadows{", euiXScrollWithShadows(euiThemeContext), ";}[class*='eui-showFor']{display:none!important;}", Object.keys(euiThemeContext.euiTheme.breakpoint).map(function (size) {
    return "\n      .eui-hideFor--".concat(size, " {\n        ").concat(euiBreakpoint(euiThemeContext, [size]), " {\n          display: none !important;\n        }\n      }\n      .eui-showFor--").concat(size, " {\n        ").concat(euiBreakpoint(euiThemeContext, [size]), " {\n          display: inline !important;\n        }\n      }\n      .eui-showFor--").concat(size, "--block {\n        ").concat(euiBreakpoint(euiThemeContext, [size]), " {\n          display: block !important;\n        }\n      }\n      .eui-showFor--").concat(size, "--inlineBlock {\n        ").concat(euiBreakpoint(euiThemeContext, [size]), " {\n          display: inline-block !important;\n        }\n      }\n      .eui-showFor--").concat(size, "--flex {\n        ").concat(euiBreakpoint(euiThemeContext, [size]), " {\n          display: flex !important;\n        }\n      }");
  }), ";;label:globalStyles;");
};
export var EuiUtilityClasses = function EuiUtilityClasses() {
  var euiTheme = useEuiTheme();
  return ___EmotionJSX(Global, {
    styles: globalStyles(euiTheme)
  });
};