import _extends from "@babel/runtime/helpers/extends";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { forwardRef, useContext, useMemo } from 'react';
import { EuiThemeContext, EuiModificationsContext, EuiColorModeContext, defaultComputedTheme, EuiNestedThemeContext } from './context';
import { emitEuiProviderWarning } from './warning';
import { jsx as ___EmotionJSX } from "@emotion/react";
var providerMessage = "`EuiProvider` is missing which can result in negative effects.\nWrap your component in `EuiProvider`: https://ela.st/euiprovider.";

/**
 * Hook for function components
 */

export var useEuiTheme = function useEuiTheme() {
  var theme = useContext(EuiThemeContext);
  var colorMode = useContext(EuiColorModeContext);
  var modifications = useContext(EuiModificationsContext);
  var isFallback = theme === defaultComputedTheme;
  if (isFallback) {
    emitEuiProviderWarning(providerMessage);
  }
  var assembledTheme = useMemo(function () {
    return {
      euiTheme: theme,
      colorMode: colorMode,
      modifications: modifications
    };
  }, [theme, colorMode, modifications]);
  return assembledTheme;
};

/**
 * HOC for class components
 */

// Provide the component props interface as the generic to allow the docs props table to populate.
// e.g., `const EuiComponent = withEuiTheme<EuiComponentProps>(_EuiComponent)`
export var withEuiTheme = function withEuiTheme(Component) {
  var componentName = Component.displayName || Component.name || 'ComponentWithTheme';
  var Render = function Render(props, ref) {
    var theme = useEuiTheme();
    return ___EmotionJSX(Component, _extends({
      theme: theme,
      ref: ref
    }, props));
  };
  var WithEuiTheme = /*#__PURE__*/forwardRef(Render);
  WithEuiTheme.displayName = componentName;
  return WithEuiTheme;
};

/**
 * Render prop alternative for complex class components
 * Most useful for scenarios where a HOC may interfere with typing
 */
export var RenderWithEuiTheme = function RenderWithEuiTheme(_ref) {
  var children = _ref.children;
  var theme = useEuiTheme();
  return children(theme);
};

/**
 * Minor syntactical sugar hook for theme CSS variables.
 * Primarily meant for internal EUI usage.
 */
export var useEuiThemeCSSVariables = function useEuiThemeCSSVariables() {
  var _useContext = useContext(EuiNestedThemeContext),
    setGlobalCSSVariables = _useContext.setGlobalCSSVariables,
    globalCSSVariables = _useContext.globalCSSVariables,
    setNearestThemeCSSVariables = _useContext.setNearestThemeCSSVariables,
    themeCSSVariables = _useContext.themeCSSVariables;
  return {
    setGlobalCSSVariables: setGlobalCSSVariables,
    globalCSSVariables: globalCSSVariables,
    setNearestThemeCSSVariables: setNearestThemeCSSVariables,
    themeCSSVariables: themeCSSVariables
  };
};