import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import _taggedTemplateLiteral from "@babel/runtime/helpers/taggedTemplateLiteral";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import { css as _css } from "@emotion/react";
var _excluded = ["cloneElement", "className"];
var _templateObject;
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useContext, useEffect, useRef, useMemo, useState, useCallback, Fragment } from 'react';
import { Global } from '@emotion/react';
import isEqual from 'lodash/isEqual';
import { cloneElementWithCss } from '../emotion';
import { css, cx } from '../emotion/css';
import { CurrentEuiBreakpointProvider } from '../breakpoint/current_breakpoint';
import { EuiSystemContext, EuiThemeContext, EuiNestedThemeContext, EuiModificationsContext, EuiColorModeContext } from './context';
import { EuiEmotionThemeProvider } from './emotion';
import { EuiThemeMemoizedStylesProvider } from './style_memoization';
import { buildTheme, getColorMode, getComputed, mergeDeep } from './utils';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiThemeProvider = function EuiThemeProvider(_ref) {
  var _system = _ref.theme,
    _colorMode = _ref.colorMode,
    _modifications = _ref.modify,
    children = _ref.children,
    wrapperProps = _ref.wrapperProps;
  var _useContext = useContext(EuiNestedThemeContext),
    isGlobalTheme = _useContext.isGlobalTheme,
    bodyColor = _useContext.bodyColor,
    globalCSSVariables = _useContext.globalCSSVariables,
    setGlobalCSSVariables = _useContext.setGlobalCSSVariables;
  var parentSystem = useContext(EuiSystemContext);
  var parentModifications = useContext(EuiModificationsContext);
  var parentColorMode = useContext(EuiColorModeContext);
  var parentTheme = useContext(EuiThemeContext);
  var _useState = useState(_system || parentSystem),
    _useState2 = _slicedToArray(_useState, 2),
    system = _useState2[0],
    setSystem = _useState2[1];
  var prevSystemKey = useRef(system.key);

  // To reduce the number of window resize listeners, only render a
  // CurrentEuiBreakpointProvider for the top level parent theme, or for
  // nested themes only if modified breakpoint overrides are passed
  var EuiConditionalBreakpointProvider = useMemo(function () {
    return isGlobalTheme || _modifications !== null && _modifications !== void 0 && _modifications.breakpoint ? CurrentEuiBreakpointProvider : Fragment;
  }, [isGlobalTheme, _modifications]);
  var _useState3 = useState(mergeDeep(parentModifications, _modifications)),
    _useState4 = _slicedToArray(_useState3, 2),
    modifications = _useState4[0],
    setModifications = _useState4[1];
  var prevModifications = useRef(modifications);
  var _useState5 = useState(getColorMode(_colorMode, parentColorMode)),
    _useState6 = _slicedToArray(_useState5, 2),
    colorMode = _useState6[0],
    setColorMode = _useState6[1];
  var prevColorMode = useRef(colorMode);
  var isParentTheme = useRef(prevSystemKey.current === parentSystem.key && colorMode === parentColorMode && isEqual(parentModifications, modifications));
  var _useState7 = useState(isParentTheme.current && Object.keys(parentTheme).length ? _objectSpread({}, parentTheme) // Intentionally create a new object to break referential equality
    : getComputed(system, buildTheme(modifications, "_".concat(system.key)), colorMode)),
    _useState8 = _slicedToArray(_useState7, 2),
    theme = _useState8[0],
    setTheme = _useState8[1];
  useEffect(function () {
    var newSystem = _system || parentSystem;
    if (prevSystemKey.current !== newSystem.key) {
      setSystem(newSystem);
      prevSystemKey.current = newSystem.key;
      isParentTheme.current = false;
    }
  }, [_system, parentSystem]);
  useEffect(function () {
    var newModifications = mergeDeep(parentModifications, _modifications);
    if (!isEqual(prevModifications.current, newModifications)) {
      setModifications(newModifications);
      prevModifications.current = newModifications;
      isParentTheme.current = false;
    }
  }, [_modifications, parentModifications]);
  useEffect(function () {
    var newColorMode = getColorMode(_colorMode, parentColorMode);
    if (!isEqual(newColorMode, prevColorMode.current)) {
      setColorMode(newColorMode);
      prevColorMode.current = newColorMode;
      isParentTheme.current = false;
    }
  }, [_colorMode, parentColorMode]);
  useEffect(function () {
    if (!isParentTheme.current) {
      setTheme(getComputed(system, buildTheme(modifications, "_".concat(system.key)), colorMode));
    }
  }, [colorMode, system, modifications]);
  var _useState9 = useState(),
    _useState10 = _slicedToArray(_useState9, 2),
    themeCSSVariables = _useState10[0],
    _setThemeCSSVariables = _useState10[1];
  var setThemeCSSVariables = useCallback(function (variables) {
    return _setThemeCSSVariables(function (previous) {
      return _objectSpread(_objectSpread({}, previous), variables);
    });
  }, []);
  var nestedThemeContext = useMemo(function () {
    return {
      isGlobalTheme: false,
      // The theme that determines the global body styles
      bodyColor: isGlobalTheme ? theme.colors.text : bodyColor,
      hasDifferentColorFromGlobalTheme: isGlobalTheme ? false : bodyColor !== theme.colors.text,
      colorClassName: css(_templateObject || (_templateObject = _taggedTemplateLiteral(["\n        label: euiColorMode-", ";\n        color: ", ";\n      "])), _colorMode || colorMode, theme.colors.text),
      setGlobalCSSVariables: isGlobalTheme ? setThemeCSSVariables : setGlobalCSSVariables,
      globalCSSVariables: isGlobalTheme ? themeCSSVariables : globalCSSVariables,
      setNearestThemeCSSVariables: setThemeCSSVariables,
      themeCSSVariables: themeCSSVariables
    };
  }, [theme, isGlobalTheme, bodyColor, _colorMode, colorMode, setGlobalCSSVariables, globalCSSVariables, setThemeCSSVariables, themeCSSVariables]);
  var renderedChildren = useMemo(function () {
    if (isGlobalTheme) {
      return children; // No wrapper
    }
    var _ref2 = wrapperProps || {},
      cloneElement = _ref2.cloneElement,
      className = _ref2.className,
      rest = _objectWithoutProperties(_ref2, _excluded);
    var props = _objectSpread(_objectSpread({}, rest), {}, {
      className: cx(className, nestedThemeContext.colorClassName)
    });
    // Condition avoids rendering an empty Emotion selector if no
    // theme-specific CSS variables have been set by child components
    if (themeCSSVariables) {
      props.css = _objectSpread({
        label: 'euiCSSVariables'
      }, themeCSSVariables);
    }
    if (cloneElement) {
      return cloneElementWithCss(children, _objectSpread(_objectSpread({}, props), {}, {
        className: cx(children.props.className, props.className)
      }));
    } else {
      return ___EmotionJSX("span", _extends({}, props, {
        className: cx('euiThemeProvider', props.className)
      }), children);
    }
  }, [isGlobalTheme, themeCSSVariables, nestedThemeContext, wrapperProps, children]);
  return ___EmotionJSX(React.Fragment, null, isGlobalTheme && themeCSSVariables && ___EmotionJSX(Global, {
    styles: /*#__PURE__*/_css({
      ':root': themeCSSVariables
    }, ";label:EuiThemeProvider;")
  }), ___EmotionJSX(EuiColorModeContext.Provider, {
    value: colorMode
  }, ___EmotionJSX(EuiSystemContext.Provider, {
    value: system
  }, ___EmotionJSX(EuiModificationsContext.Provider, {
    value: modifications
  }, ___EmotionJSX(EuiThemeContext.Provider, {
    value: theme
  }, ___EmotionJSX(EuiNestedThemeContext.Provider, {
    value: nestedThemeContext
  }, ___EmotionJSX(EuiThemeMemoizedStylesProvider, null, ___EmotionJSX(EuiEmotionThemeProvider, null, ___EmotionJSX(EuiConditionalBreakpointProvider, null, renderedChildren)))))))));
};