import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { queryHelpers, buildQueries } from '@testing-library/react';
var queryAllByTestSubject = function queryAllByTestSubject() {
  for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
    args[_key] = arguments[_key];
  }
  return queryHelpers.queryAllByAttribute.apply(queryHelpers, ['data-test-subj'].concat(args));
};
var getMultipleError = function getMultipleError(_, TestSubjectValue) {
  return "Found multiple elements with the data-test-subj attribute of: ".concat(TestSubjectValue);
};
var getMissingError = function getMissingError(_, TestSubjectValue) {
  return "Unable to find an element with the data-test-subj attribute of: ".concat(TestSubjectValue);
};
var _buildQueries = buildQueries(queryAllByTestSubject, getMultipleError, getMissingError),
  _buildQueries2 = _slicedToArray(_buildQueries, 5),
  queryByTestSubject = _buildQueries2[0],
  getAllByTestSubject = _buildQueries2[1],
  getByTestSubject = _buildQueries2[2],
  findAllByTestSubject = _buildQueries2[3],
  findByTestSubject = _buildQueries2[4];
export { queryByTestSubject, queryAllByTestSubject, getByTestSubject, getAllByTestSubject, findAllByTestSubject, findByTestSubject };