"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiScreenReaderOnly = void 0;
var _react = require("react");
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../../services");
var _screen_reader_only = require("./screen_reader_only.styles");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var EuiScreenReaderOnly = exports.EuiScreenReaderOnly = function EuiScreenReaderOnly(_ref) {
  var children = _ref.children,
    className = _ref.className,
    showOnFocus = _ref.showOnFocus;
  var classes = (0, _classnames.default)(className, children.props.className);
  var props = (0, _react.useMemo)(function () {
    return {
      className: classes.length ? classes : undefined,
      css: showOnFocus ? _screen_reader_only.euiScreenReaderOnlyStyles['euiScreenReaderOnly-showOnFocus'] : _screen_reader_only.euiScreenReaderOnlyStyles.euiScreenReaderOnly
    };
  }, [classes, showOnFocus]);
  return (0, _services.cloneElementWithCss)(children, props);
};