"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiAccordionArrow = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../../services");
var _button = require("../../button");
var _accordion_arrow = require("./accordion_arrow.styles");
var _react2 = require("@emotion/react");
var _excluded = ["arrowDisplay", "arrowProps", "isOpen"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var EuiAccordionArrow = exports.EuiAccordionArrow = function EuiAccordionArrow(_ref) {
  var _ref$arrowDisplay = _ref.arrowDisplay,
    arrowDisplay = _ref$arrowDisplay === void 0 ? 'left' : _ref$arrowDisplay,
    arrowProps = _ref.arrowProps,
    isOpen = _ref.isOpen,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var euiTheme = (0, _services.useEuiTheme)();
  if (arrowDisplay === 'none') return null;
  var styles = (0, _accordion_arrow.euiAccordionArrowStyles)(euiTheme);
  var cssStyles = [styles.euiAccordion__arrow, styles[arrowDisplay], isOpen ? styles.isOpen : styles.isClosed, arrowProps === null || arrowProps === void 0 ? void 0 : arrowProps.css];
  var classes = (0, _classnames.default)('euiAccordion__arrow', arrowProps === null || arrowProps === void 0 ? void 0 : arrowProps.className);
  return (0, _react2.jsx)(_button.EuiButtonIcon, (0, _extends2.default)({
    color: "text"
  }, arrowProps, rest, {
    className: classes,
    css: cssStyles,
    iconType: "arrowRight"
  }));
};