"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiAccordionButton = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../../services");
var _accordion_button = require("./accordion_button.styles");
var _react2 = require("@emotion/react");
var _excluded = ["buttonElement", "buttonProps", "buttonClassName", "buttonContentClassName", "isDisabled", "arrowDisplay", "children"],
  _excluded2 = ["paddingSize"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var EuiAccordionButton = exports.EuiAccordionButton = function EuiAccordionButton(_ref) {
  var ButtonElement = _ref.buttonElement,
    _buttonProps = _ref.buttonProps,
    buttonClassName = _ref.buttonClassName,
    buttonContentClassName = _ref.buttonContentClassName,
    isDisabled = _ref.isDisabled,
    arrowDisplay = _ref.arrowDisplay,
    children = _ref.children,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var _ref2 = _buttonProps || {},
    paddingSize = _ref2.paddingSize,
    buttonProps = (0, _objectWithoutProperties2.default)(_ref2, _excluded2);
  var classes = (0, _classnames.default)('euiAccordion__button', buttonClassName, buttonProps.className);
  var buttonContentClasses = (0, _classnames.default)('euiAccordion__buttonContent', buttonContentClassName);
  var euiTheme = (0, _services.useEuiTheme)();
  var styles = (0, _accordion_button.euiAccordionButtonStyles)(euiTheme);
  var cssStyles = [styles.euiAccordion__button, isDisabled && styles.disabled].concat((0, _toConsumableArray2.default)(paddingSize ? [styles[paddingSize], arrowDisplay === 'left' && styles.arrowLeft, arrowDisplay === 'right' && styles.arrowRight] : []), [buttonProps.css]);
  var elementIsButton = ButtonElement === 'button';
  return (0, _react2.jsx)(ButtonElement, (0, _extends2.default)({}, buttonProps, rest, {
    className: classes,
    css: cssStyles,
    type: elementIsButton ? 'button' : undefined,
    disabled: elementIsButton ? isDisabled : undefined
  }), (0, _react2.jsx)("span", {
    className: buttonContentClasses
  }, children));
};