"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.checkValidColor = exports.TYPES = exports.SIZES = exports.EuiAvatar = exports.CASING = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _color = require("../../services/color");
var _services = require("../../services");
var _icon = require("../icon");
var _avatar = require("./avatar.styles");
var _react2 = require("@emotion/react");
var _excluded = ["className", "color", "imageUrl", "initials", "initialsLength", "iconType", "iconSize", "iconColor", "name", "size", "type", "isDisabled", "style"],
  _excluded2 = ["casing"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var visColors = (0, _services.euiPaletteColorBlindBehindText)();
var SIZES = exports.SIZES = ['s', 'm', 'l', 'xl'];
var TYPES = exports.TYPES = ['space', 'user'];
var CASING = exports.CASING = ['capitalize', 'uppercase', 'lowercase', 'none'];

/**
 * The avatar can only display one type of content,
 * initials, or image, or iconType
 */

var EuiAvatar = exports.EuiAvatar = function EuiAvatar(_ref) {
  var className = _ref.className,
    color = _ref.color,
    imageUrl = _ref.imageUrl,
    initials = _ref.initials,
    initialsLength = _ref.initialsLength,
    iconType = _ref.iconType,
    iconSize = _ref.iconSize,
    iconColor = _ref.iconColor,
    name = _ref.name,
    _ref$size = _ref.size,
    size = _ref$size === void 0 ? 'm' : _ref$size,
    _ref$type = _ref.type,
    type = _ref$type === void 0 ? 'user' : _ref$type,
    _ref$isDisabled = _ref.isDisabled,
    isDisabled = _ref$isDisabled === void 0 ? false : _ref$isDisabled,
    style = _ref.style,
    props = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  checkValidInitials(initials);
  var _props$casing = props.casing,
    casing = _props$casing === void 0 ? type === 'space' ? 'none' : 'uppercase' : _props$casing,
    rest = (0, _objectWithoutProperties2.default)(props, _excluded2);
  var isPlain = color === 'plain';
  var isSubdued = color === 'subdued';
  var isNamedColor = isPlain || isSubdued || color === null;
  var classes = (0, _classnames.default)('euiAvatar', (0, _defineProperty2.default)((0, _defineProperty2.default)((0, _defineProperty2.default)({}, "euiAvatar--".concat(size), size), "euiAvatar--".concat(type), type), 'euiAvatar-isDisabled', isDisabled), className);
  var styles = (0, _services.useEuiMemoizedStyles)(_avatar.euiAvatarStyles);
  var cssStyles = [styles.euiAvatar, styles[type], styles[size], styles[casing], isPlain && styles.plain, isSubdued && styles.subdued, isDisabled && styles.isDisabled];
  var avatarStyle = (0, _react.useMemo)(function () {
    if (imageUrl) {
      return {
        backgroundImage: "url(".concat(imageUrl, ")")
      };
    }
    if (!isNamedColor) {
      checkValidColor(color);
      var assignedColor = color || visColors[Math.floor(name.length % visColors.length)];
      var textColor = _color.isColorDark.apply(void 0, (0, _toConsumableArray2.default)((0, _color.hexToRgb)(assignedColor))) ? '#FFFFFF' : '#000000';
      return {
        backgroundColor: assignedColor,
        color: textColor
      };
    }
  }, [imageUrl, color, isNamedColor, name.length]);
  var iconCustomColor = (0, _react.useMemo)(function () {
    // `null` allows icons to keep their default color (e.g. app icons)
    if (iconColor === null) return undefined;
    // Otherwise continue to pass on `iconColor`
    if (iconColor) return iconColor;
    // Fall back to the adjusted text color if it exists
    return avatarStyle === null || avatarStyle === void 0 ? void 0 : avatarStyle.color;
  }, [iconColor, avatarStyle === null || avatarStyle === void 0 ? void 0 : avatarStyle.color]);
  return (0, _react2.jsx)("div", (0, _extends2.default)({
    css: cssStyles,
    className: classes,
    style: _objectSpread(_objectSpread({}, style), avatarStyle),
    "aria-label": isDisabled ? undefined : name,
    role: isDisabled ? 'presentation' : 'img',
    title: name
  }, rest), !imageUrl && (iconType ? (0, _react2.jsx)(_icon.EuiIcon, {
    className: "euiAvatar__icon",
    size: iconSize || size,
    type: iconType,
    color: iconCustomColor
  }) : (0, _react2.jsx)("span", {
    "aria-hidden": "true"
  }, (0, _services.toInitials)(name, initialsLength, initials))));
};

// TODO: Migrate to a service
var checkValidColor = exports.checkValidColor = function checkValidColor(color) {
  var validHex = color && (0, _color.isValidHex)(color) || color === 'plain' || color === 'subdued';
  if (color && !validHex) {
    throw new Error('EuiAvatar needs to pass a valid color. This can either be a three ' + 'or six character hex value');
  }
};
function checkValidInitials(initials) {
  // Must be a string of 1 or 2 characters
  if (initials && initials.length > 2) {
    console.warn('EuiAvatar only accepts a max of 2 characters for the initials as a string. It is displaying only the first 2 characters.');
  }
}