"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ICON_SIDES = exports.EuiBadge = exports.COLORS = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _href_validator = require("../../services/security/href_validator");
var _inner_text = require("../inner_text");
var _icon = require("../icon");
var _color_utils = require("./color_utils");
var _badge = require("./badge.styles");
var _react2 = require("@emotion/react");
var _excluded = ["children", "color", "iconType", "iconSide", "className", "isDisabled", "onClick", "iconOnClick", "onClickAriaLabel", "iconOnClickAriaLabel", "closeButtonProps", "href", "rel", "target", "style"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var ICON_SIDES = exports.ICON_SIDES = ['left', 'right'];
var COLORS = exports.COLORS = ['default', 'hollow', 'primary', 'success', 'accent', 'warning', 'danger'];
var EuiBadge = exports.EuiBadge = function EuiBadge(_ref) {
  var children = _ref.children,
    _ref$color = _ref.color,
    color = _ref$color === void 0 ? 'default' : _ref$color,
    iconType = _ref.iconType,
    _ref$iconSide = _ref.iconSide,
    iconSide = _ref$iconSide === void 0 ? 'left' : _ref$iconSide,
    className = _ref.className,
    _isDisabled = _ref.isDisabled,
    onClick = _ref.onClick,
    iconOnClick = _ref.iconOnClick,
    onClickAriaLabel = _ref.onClickAriaLabel,
    iconOnClickAriaLabel = _ref.iconOnClickAriaLabel,
    closeButtonProps = _ref.closeButtonProps,
    href = _ref.href,
    rel = _ref.rel,
    target = _ref.target,
    style = _ref.style,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var isHrefValid = !href || (0, _href_validator.validateHref)(href);
  var isDisabled = _isDisabled || !isHrefValid;
  var isNamedColor = COLORS.includes(color);
  var euiTheme = (0, _services.useEuiTheme)();
  var customColorStyles = (0, _react.useMemo)(function () {
    // Disabled badges should not have custom colors
    if (isDisabled) return style;
    // Named colors set their styles via Emotion CSS and not inline styles
    if (isNamedColor) return style;

    // Do our best to ensure custom colors provide sufficient contrast
    try {
      // Set dark or light text color based upon best contrast
      var textColor = (0, _color_utils.getTextColor)(euiTheme, color);

      // Check the contrast ratio. If it's low contrast, emit a console awrning
      var contrastRatio = (0, _color_utils.getColorContrast)(textColor, color);
      if (contrastRatio < _services.wcagContrastMin) {
        console.warn("Warning: ".concat(color, " badge has a low contrast of ").concat(contrastRatio.toFixed(2), ". Should be above ").concat(_services.wcagContrastMin, "."));
      }
      return _objectSpread({
        '--euiBadgeBackgroundColor': color,
        '--euiBadgeTextColor': textColor
      }, style);
    } catch (err) {
      if (!(0, _color_utils.getIsValidColor)(color)) {
        console.warn('EuiBadge expects a valid color. This can either be a three or six ' + "character hex value, rgb(a) value, hsv value, hollow, or one of the following: ".concat(COLORS, ". ") + "Instead got ".concat(color, "."));
      }
    }
  }, [color, isNamedColor, isDisabled, style, euiTheme]);
  var styles = (0, _services.useEuiMemoizedStyles)(_badge.euiBadgeStyles);
  var cssStyles = [styles.euiBadge].concat((0, _toConsumableArray2.default)(isDisabled ? [styles.disabled] : [isNamedColor && styles[color], !iconOnClick && (onClick || href) && styles.clickable]));
  var textCssStyles = [styles.text.euiBadge__text, (onClick || href) && !isDisabled && styles.text.clickable];
  var iconCssStyles = [styles.icon.euiBadge__icon, styles.icon[iconSide]];
  var iconButtonCssStyles = [styles.iconButton.euiBadge__iconButton, styles.iconButton[iconSide]];
  var classes = (0, _classnames.default)('euiBadge', className);
  var closeClassNames = (0, _classnames.default)('euiBadge__icon', closeButtonProps === null || closeButtonProps === void 0 ? void 0 : closeButtonProps.className);
  var Element = href && !isDisabled ? 'a' : 'button';
  var relObj = {};
  if (href && !isDisabled) {
    relObj.href = href;
    relObj.target = target;
    relObj.rel = (0, _services.getSecureRelForTarget)({
      href: href,
      target: target,
      rel: rel
    });
  }
  if (onClick) {
    relObj.onClick = onClick;
  }
  var optionalIcon = null;
  if (iconType) {
    if (iconOnClick) {
      if (!iconOnClickAriaLabel) {
        console.warn('When passing the iconOnClick props to EuiBadge, you must also provide iconOnClickAriaLabel');
      }
      optionalIcon = (0, _react2.jsx)("button", {
        type: "button",
        className: "euiBadge__iconButton",
        css: iconButtonCssStyles,
        "aria-label": iconOnClickAriaLabel,
        disabled: isDisabled,
        title: iconOnClickAriaLabel,
        onClick: iconOnClick
      }, (0, _react2.jsx)(_icon.EuiIcon, (0, _extends2.default)({
        type: iconType,
        size: "s",
        color: "inherit" // forces the icon to inherit its parent color
      }, closeButtonProps, {
        className: closeClassNames,
        css: [].concat(iconCssStyles, [closeButtonProps === null || closeButtonProps === void 0 ? void 0 : closeButtonProps.css])
      })));
    } else {
      optionalIcon = (0, _react2.jsx)(_icon.EuiIcon, {
        type: iconType,
        size: children ? 's' : 'm',
        className: "euiBadge__icon",
        css: iconCssStyles,
        color: "inherit" // forces the icon to inherit its parent color
      });
    }
  }
  if (onClick && !onClickAriaLabel) {
    console.warn('When passing onClick to EuiBadge, you must also provide onClickAriaLabel');
  }
  var content = (0, _react2.jsx)("span", {
    className: "euiBadge__content",
    css: styles.euiBadge__content
  }, iconSide === 'left' && optionalIcon, children && (0, _react2.jsx)("span", {
    className: "euiBadge__text",
    css: textCssStyles
  }, children), iconSide === 'right' && optionalIcon);
  if (iconOnClick) {
    return onClick || href ? (0, _react2.jsx)("span", {
      className: classes,
      css: cssStyles,
      style: customColorStyles
    }, (0, _react2.jsx)("span", {
      className: "euiBadge__content",
      css: styles.euiBadge__content
    }, iconSide === 'left' && optionalIcon, (0, _react2.jsx)(_inner_text.EuiInnerText, null, function (ref, innerText) {
      return (0, _react2.jsx)(Element, (0, _extends2.default)({
        className: "euiBadge__childButton",
        css: styles.euiBadge__childButton,
        disabled: isDisabled,
        "aria-label": onClickAriaLabel,
        ref: ref,
        title: innerText
      }, relObj, rest), children);
    }), iconSide === 'right' && optionalIcon)) : (0, _react2.jsx)(_inner_text.EuiInnerText, null, function (ref, innerText) {
      return (0, _react2.jsx)("span", (0, _extends2.default)({
        className: classes,
        css: cssStyles,
        style: customColorStyles,
        ref: ref,
        title: innerText
      }, rest), content);
    });
  } else if (onClick || href) {
    return (0, _react2.jsx)(_inner_text.EuiInnerText, null, function (ref, innerText) {
      return (0, _react2.jsx)(Element, (0, _extends2.default)({
        disabled: isDisabled,
        "aria-label": onClickAriaLabel,
        className: classes,
        css: cssStyles,
        style: customColorStyles,
        ref: ref,
        title: innerText
      }, relObj, rest), content);
    });
  } else {
    return (0, _react2.jsx)(_inner_text.EuiInnerText, null, function (ref, innerText) {
      return (0, _react2.jsx)("span", (0, _extends2.default)({
        className: classes,
        css: cssStyles,
        style: customColorStyles,
        ref: ref,
        title: innerText
      }, rest), content);
    });
  }
};