"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _react = _interopRequireWildcard(require("react"));
var _basic_table = require("./basic_table");
var _button = require("../button");
var _health = require("../health");
var _link = require("../link");
var _accessibility = require("../accessibility");
var _services = require("../../services");
var _faker = require("@faker-js/faker");
var _react2 = require("@emotion/react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */ /// <reference types="cypress" />
/// <reference types="cypress-real-events" />
/// <reference types="../../../cypress/support" />
var users = [];
for (var i = 0; i < 20; i++) {
  users.push({
    id: i + 1,
    firstName: _faker.faker.person.firstName(),
    lastName: _faker.faker.person.lastName(),
    github: _faker.faker.internet.userName(),
    dateOfBirth: _faker.faker.date.past(),
    online: _faker.faker.datatype.boolean(),
    location: {
      city: _faker.faker.location.city(),
      country: _faker.faker.location.country()
    }
  });
}
var columns = [{
  field: 'firstName',
  name: 'First Name',
  sortable: true,
  truncateText: true,
  mobileOptions: {
    render: function render(user) {
      return (0, _react2.jsx)("span", null, user.firstName, " ", user.lastName);
    },
    header: false,
    truncateText: false,
    enlarge: true,
    width: '100%'
  }
}, {
  field: 'lastName',
  name: 'Last Name',
  truncateText: true,
  mobileOptions: {
    show: false
  }
}, {
  field: 'github',
  name: 'Github',
  render: function render(username) {
    return (0, _react2.jsx)(_link.EuiLink, {
      href: "#",
      target: "_blank"
    }, username);
  }
}, {
  field: 'dateOfBirth',
  name: 'Date of Birth',
  dataType: 'date',
  render: function render(dateOfBirth) {
    return (0, _services.formatDate)(dateOfBirth, 'dobLong');
  },
  sortable: true
}, {
  field: 'location',
  name: 'Location',
  truncateText: true,
  textOnly: true,
  render: function render(location) {
    return "".concat(location.city, ", ").concat(location.country);
  }
}, {
  field: 'online',
  name: 'Online',
  dataType: 'boolean',
  render: function render(online) {
    var color = online ? 'success' : 'danger';
    var label = online ? 'Online' : 'Offline';
    return (0, _react2.jsx)(_health.EuiHealth, {
      color: color
    }, label);
  },
  sortable: true,
  mobileOptions: {
    show: false
  }
}];
describe('EuiTable', function () {
  var BasicTable = function BasicTable() {
    return (0, _react2.jsx)(_basic_table.EuiBasicTable, {
      tableCaption: "Demo of EuiBasicTable",
      columns: columns,
      items: users,
      "data-test-subj": "cy-basic-table"
    });
  };
  describe('Basic table', function () {
    describe('Automated accessibility check', function () {
      it('has zero violations on render', function () {
        cy.viewport(1024, 768); // medium breakpoint
        cy.realMount((0, _react2.jsx)(BasicTable, null));
        cy.get('[data-test-subj="cy-basic-table"]').should('exist');
        cy.checkAxe();
      });
    });
  });
  describe('Mobile basic table', function () {
    describe('Automated accessibility check', function () {
      it('has zero violations on render', function () {
        cy.viewport(375, 667); // small breakpoint
        cy.realMount((0, _react2.jsx)(BasicTable, null));
        cy.get('[data-test-subj="cy-basic-table"]').should('exist');
        cy.checkAxe();
      });
    });
  });
  describe('Expandable rows', function () {
    var ExpandableRowTable = function ExpandableRowTable() {
      var _useState = (0, _react.useState)({}),
        _useState2 = (0, _slicedToArray2.default)(_useState, 2),
        itemIdToExpandedRowMap = _useState2[0],
        setItemIdToExpandedRowMap = _useState2[1];
      var toggleDetails = function toggleDetails(user) {
        var itemIdToExpandedRowMapValues = _objectSpread({}, itemIdToExpandedRowMap);
        if (itemIdToExpandedRowMapValues[user.id]) {
          delete itemIdToExpandedRowMapValues[user.id];
        } else {
          itemIdToExpandedRowMapValues[user.id] = (0, _react2.jsx)("div", null, (0, _react2.jsx)("p", null, "Location: ".concat(user.location.city)), (0, _react2.jsx)("p", null, "This person is online."));
        }
        setItemIdToExpandedRowMap(itemIdToExpandedRowMapValues);
      };
      var columnsWithExpandingRowToggle = [].concat(columns, [{
        align: 'right',
        width: '40px',
        isExpander: true,
        name: (0, _react2.jsx)(_accessibility.EuiScreenReaderOnly, null, (0, _react2.jsx)("span", null, "Expand rows")),
        render: function render(user) {
          var itemIdToExpandedRowMapValues = _objectSpread({}, itemIdToExpandedRowMap);
          return (0, _react2.jsx)(_button.EuiButtonIcon, {
            id: user.id.toString(),
            onClick: function onClick() {
              return toggleDetails(user);
            },
            "aria-label": itemIdToExpandedRowMapValues[user.id] ? 'Collapse' : 'Expand',
            iconType: itemIdToExpandedRowMapValues[user.id] ? 'arrowDown' : 'arrowRight'
          });
        }
      }]);
      return (0, _react2.jsx)(_basic_table.EuiBasicTable, {
        tableCaption: "Demo of EuiBasicTable with expanding rows",
        itemIdToExpandedRowMap: itemIdToExpandedRowMap,
        isExpandable: true,
        columns: columnsWithExpandingRowToggle,
        items: users,
        itemId: "id",
        "data-test-subj": "cy-expandable-row-table"
      });
    };
    beforeEach(function () {
      cy.viewport(1024, 768); // medium breakpoint
      cy.realMount((0, _react2.jsx)(ExpandableRowTable, null));
      cy.get('[data-test-subj="cy-expandable-row-table"]').should('exist');
    });
    describe('Automated accessibility check', function () {
      it('has zero violations on render', function () {
        cy.checkAxe();
      });
    });
    describe('Keyboard accessibility', function () {
      it('has zero violations after expanding a row', function () {
        cy.get('button#1').focus();
        cy.realPress('Enter');
        cy.get('tr.euiTableRow-isExpandedRow div.euiTableCellContent').should('exist');
        cy.checkAxe();
      });
    });
  });
});