"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CollapsedItemActions = void 0;
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _react = _interopRequireWildcard(require("react"));
var _context_menu = require("../context_menu");
var _popover = require("../popover");
var _button = require("../button");
var _tool_tip = require("../tool_tip");
var _i18n = require("../i18n");
var _action_types = require("./action_types");
var _react2 = require("@emotion/react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var CollapsedItemActions = exports.CollapsedItemActions = function CollapsedItemActions(_ref) {
  var actions = _ref.actions,
    itemId = _ref.itemId,
    item = _ref.item,
    actionsDisabled = _ref.actionsDisabled,
    displayedRowIndex = _ref.displayedRowIndex,
    className = _ref.className;
  var _useState = (0, _react.useState)(false),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    popoverOpen = _useState2[0],
    setPopoverOpen = _useState2[1];
  var closePopover = (0, _react.useCallback)(function () {
    return setPopoverOpen(false);
  }, []);
  var allActionsTooltip = (0, _i18n.useEuiI18n)('euiCollapsedItemActions.allActionsTooltip', 'All actions');
  var allActionsButtonAriaLabel = (0, _i18n.useEuiI18n)('euiCollapsedItemActions.allActions', 'All actions, row {index}', {
    index: displayedRowIndex + 1
  });
  var allActionsButtonDisabledAriaLabel = (0, _i18n.useEuiI18n)('euiCollapsedItemActions.allActionsDisabled', 'Individual item actions are disabled when rows are being selected.');
  var controls = (0, _react.useMemo)(function () {
    return actions.reduce(function (controls, action, index) {
      var _action$available, _action$available2;
      var available = (_action$available = (_action$available2 = action.available) === null || _action$available2 === void 0 ? void 0 : _action$available2.call(action, item)) !== null && _action$available !== void 0 ? _action$available : true;
      if (!available) return controls;
      var enabled = action.enabled == null || action.enabled(item);
      if ((0, _action_types.isCustomItemAction)(action)) {
        var customAction = action;
        var actionControl = customAction.render(item, enabled);
        controls.push(
        // Do not put the `onClick` on the EuiContextMenuItem itself - otherwise
        // it renders a <button> tag instead of a <div>, and we end up with nested
        // interactive elements
        (0, _react2.jsx)(_context_menu.EuiContextMenuItem, {
          key: index,
          className: "euiBasicTable__collapsedCustomAction"
        }, (0, _react2.jsx)("span", {
          onClick: closePopover
        }, actionControl)));
      } else {
        var icon = action.icon ? (0, _action_types.callWithItemIfFunction)(item)(action.icon) : undefined;
        var buttonContent = (0, _action_types.callWithItemIfFunction)(item)(action.name);
        var toolTipContent = (0, _action_types.callWithItemIfFunction)(item)(action.description);
        var href = (0, _action_types.callWithItemIfFunction)(item)(action.href);
        var dataTestSubj = (0, _action_types.callWithItemIfFunction)(item)(action['data-test-subj']);
        var _onClick = action.onClick,
          target = action.target;
        controls.push((0, _react2.jsx)(_context_menu.EuiContextMenuItem, {
          key: index,
          className: "euiBasicTable__collapsedAction",
          disabled: !enabled && !actionsDisabled,
          href: href,
          target: target,
          icon: icon,
          "data-test-subj": dataTestSubj,
          onClick: function onClick(event) {
            event.persist();
            _onClick === null || _onClick === void 0 || _onClick(item, event);
            // Allow consumer events to prevent the popover from closing if necessary
            if (!event.isPropagationStopped()) closePopover();
          },
          toolTipContent: toolTipContent,
          toolTipProps: {
            delay: 'long'
          }
        }, buttonContent));
      }
      return controls;
    }, []);
  }, [actions, actionsDisabled, item, closePopover]);
  var popoverButton = (0, _react2.jsx)(_button.EuiButtonIcon, {
    className: className,
    "aria-label": actionsDisabled ? allActionsButtonDisabledAriaLabel : allActionsButtonAriaLabel,
    title: actionsDisabled ? allActionsButtonDisabledAriaLabel : undefined,
    iconType: "boxesHorizontal",
    color: "text",
    isDisabled: actionsDisabled,
    onClick: function onClick() {
      return setPopoverOpen(function (isOpen) {
        return !isOpen;
      });
    },
    "data-test-subj": "euiCollapsedItemActionsButton"
  });
  var withTooltip = !actionsDisabled && (0, _react2.jsx)(_tool_tip.EuiToolTip, {
    content: allActionsTooltip,
    delay: "long"
  }, popoverButton);
  return (0, _react2.jsx)(_popover.EuiPopover, {
    className: className,
    id: "".concat(itemId, "-actions"),
    isOpen: popoverOpen,
    button: withTooltip || popoverButton,
    closePopover: closePopover,
    panelPaddingSize: "none",
    anchorPosition: "leftCenter"
  }, (0, _react2.jsx)(_context_menu.EuiContextMenuPanel, {
    className: "euiBasicTable__collapsedActions",
    items: controls
  }));
};