"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiBreadcrumbContent = void 0;
var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _inner_text = require("../inner_text");
var _link = require("../link");
var _popover = require("../popover");
var _icon = require("../icon");
var _i18n = require("../i18n");
var _breadcrumb_content = require("./_breadcrumb_content.styles");
var _react2 = require("@emotion/react");
var _excluded = ["text", "truncate", "type", "href", "rel", "onClick", "popoverContent", "popoverProps", "className", "color", "isFirstBreadcrumb", "isLastBreadcrumb", "isOnlyBreadcrumb", "highlightLastBreadcrumb", "truncateLastBreadcrumb"],
  _excluded2 = ["css"],
  _excluded3 = ["popoverContent", "popoverProps", "color", "type", "title", "aria-current", "className", "isLastBreadcrumb", "breadcrumbCss", "truncationCss", "children"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var EuiBreadcrumbContent = exports.EuiBreadcrumbContent = function EuiBreadcrumbContent(_ref) {
  var text = _ref.text,
    truncate = _ref.truncate,
    type = _ref.type,
    href = _ref.href,
    rel = _ref.rel,
    onClick = _ref.onClick,
    popoverContent = _ref.popoverContent,
    popoverProps = _ref.popoverProps,
    className = _ref.className,
    color = _ref.color,
    isFirstBreadcrumb = _ref.isFirstBreadcrumb,
    isLastBreadcrumb = _ref.isLastBreadcrumb,
    isOnlyBreadcrumb = _ref.isOnlyBreadcrumb,
    highlightLastBreadcrumb = _ref.highlightLastBreadcrumb,
    truncateLastBreadcrumb = _ref.truncateLastBreadcrumb,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var isApplication = type === 'application';
  var classes = (0, _classnames.default)('euiBreadcrumb__content', className);
  var styles = (0, _services.useEuiMemoizedStyles)(_breadcrumb_content.euiBreadcrumbContentStyles);
  var cssStyles = [styles.euiBreadcrumb__content, styles[type]];
  if (isApplication) {
    if (isOnlyBreadcrumb) {
      cssStyles.push(styles.applicationStyles.onlyChild);
    } else if (isFirstBreadcrumb) {
      cssStyles.push(styles.applicationStyles.firstChild);
    } else if (isLastBreadcrumb) {
      cssStyles.push(styles.applicationStyles.lastChild);
    }
  }
  var truncationStyles = [truncate && !truncateLastBreadcrumb && styles.isTruncated, truncateLastBreadcrumb && styles.isTruncatedLast];
  var isBreadcrumbWithPopover = !!popoverContent;
  var isInteractiveBreadcrumb = href || onClick;
  var linkColor = color || 'subdued';
  var ariaCurrent = highlightLastBreadcrumb ? 'page' : undefined;
  var interactionStyles = (isInteractiveBreadcrumb || isBreadcrumbWithPopover) && !isApplication && styles.isInteractive;
  return (0, _react2.jsx)(_inner_text.EuiInnerText, null, function (ref, innerText) {
    var title = innerText === '' ? undefined : innerText;
    var baseProps = {
      ref: ref,
      title: title,
      'aria-current': ariaCurrent,
      className: classes,
      css: [].concat(cssStyles, truncationStyles, [interactionStyles])
    };
    if (isBreadcrumbWithPopover) {
      var _ = baseProps.css,
        popoverButtonProps = (0, _objectWithoutProperties2.default)(baseProps, _excluded2);
      return (0, _react2.jsx)(EuiBreadcrumbPopover, (0, _extends2.default)({}, popoverButtonProps, {
        breadcrumbCss: [].concat(cssStyles, [interactionStyles]),
        truncationCss: truncationStyles,
        isLastBreadcrumb: isLastBreadcrumb,
        type: type,
        color: linkColor,
        popoverContent: popoverContent,
        popoverProps: popoverProps
      }, rest), text);
    } else if (isInteractiveBreadcrumb) {
      return (0, _react2.jsx)(_link.EuiLink, (0, _extends2.default)({}, baseProps, {
        color: linkColor,
        onClick: onClick,
        href: href,
        rel: rel
      }, rest), text);
    } else {
      return (0, _react2.jsx)("span", (0, _extends2.default)({}, baseProps, rest), text);
    }
  });
};
var EuiBreadcrumbPopover = /*#__PURE__*/(0, _react.forwardRef)(function (_ref2, ref) {
  var popoverContent = _ref2.popoverContent,
    popoverProps = _ref2.popoverProps,
    color = _ref2.color,
    type = _ref2.type,
    title = _ref2.title,
    ariaCurrent = _ref2['aria-current'],
    className = _ref2.className,
    isLastBreadcrumb = _ref2.isLastBreadcrumb,
    breadcrumbCss = _ref2.breadcrumbCss,
    truncationCss = _ref2.truncationCss,
    children = _ref2.children,
    rest = (0, _objectWithoutProperties2.default)(_ref2, _excluded3);
  var _useState = (0, _react.useState)(false),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    isPopoverOpen = _useState2[0],
    setIsPopoverOpen = _useState2[1];
  var closePopover = (0, _react.useCallback)(function () {
    return setIsPopoverOpen(false);
  }, []);
  var togglePopover = (0, _react.useCallback)(function () {
    return setIsPopoverOpen(function (isOpen) {
      return !isOpen;
    });
  }, []);
  var popoverAriaLabel = (0, _i18n.useEuiI18n)(
  // This component was moved into another file for organization/dev readability,
  // but we're keeping the i18n token the same as before for consumer consistency
  // eslint-disable-next-line local/i18n
  'euiBreadcrumb.popoverAriaLabel', 'Clicking this button will toggle a popover dialog.');
  var styles = (0, _services.useEuiMemoizedStyles)(_breadcrumb_content.euiBreadcrumbPopoverStyles);
  var wrapperStyles = [styles.popoverWrapper.euiBreadcrumb__popoverWrapper, !isLastBreadcrumb && styles.popoverWrapper[type]];
  var buttonStyles = [styles.euiBreadcrumb__popoverButton].concat((0, _toConsumableArray2.default)(breadcrumbCss));
  var truncationStyles = [styles.euiBreadcrumb__popoverTruncation].concat((0, _toConsumableArray2.default)(truncationCss));
  return (0, _react2.jsx)(_popover.EuiPopover, (0, _extends2.default)({}, popoverProps, {
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    css: wrapperStyles,
    button: (0, _react2.jsx)(_link.EuiLink, (0, _extends2.default)({
      ref: ref,
      title: title,
      "aria-current": ariaCurrent,
      className: className,
      css: buttonStyles,
      color: color,
      onClick: togglePopover
    }, rest), (0, _react2.jsx)("span", {
      css: truncationStyles
    }, children), (0, _react2.jsx)(_icon.EuiIcon, {
      type: "arrowDown",
      size: "s",
      "aria-label": " - ".concat(popoverAriaLabel)
    }))
  }), typeof popoverContent === 'function' ? popoverContent(closePopover) : popoverContent);
});
EuiBreadcrumbPopover.displayName = 'EuiBreadcrumbPopover';