"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof3 = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useResponsiveMax = exports.limitBreadcrumbs = exports.EuiBreadcrumbs = void 0;
var _typeof2 = _interopRequireDefault(require("@babel/runtime/helpers/typeof"));
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _i18n = require("../i18n");
var _services = require("../../services");
var _breadcrumb = require("./breadcrumb");
var _breadcrumb_content = require("./_breadcrumb_content");
var _breadcrumbs = require("./breadcrumbs.styles");
var _react2 = require("@emotion/react");
var _excluded = ["breadcrumbs", "className", "responsive", "truncate", "max", "type", "lastBreadcrumbIsCurrentPage"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof3(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var responsiveDefault = {
  xs: 1,
  s: 2,
  m: 4
};
var EuiBreadcrumbs = exports.EuiBreadcrumbs = function EuiBreadcrumbs(_ref) {
  var breadcrumbs = _ref.breadcrumbs,
    className = _ref.className,
    _ref$responsive = _ref.responsive,
    responsive = _ref$responsive === void 0 ? responsiveDefault : _ref$responsive,
    _ref$truncate = _ref.truncate,
    truncate = _ref$truncate === void 0 ? true : _ref$truncate,
    _ref$max = _ref.max,
    max = _ref$max === void 0 ? 5 : _ref$max,
    _ref$type = _ref.type,
    type = _ref$type === void 0 ? 'page' : _ref$type,
    _ref$lastBreadcrumbIs = _ref.lastBreadcrumbIsCurrentPage,
    lastBreadcrumbIsCurrentPage = _ref$lastBreadcrumbIs === void 0 ? true : _ref$lastBreadcrumbIs,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var ariaLabel = (0, _i18n.useEuiI18n)('euiBreadcrumbs.nav.ariaLabel', 'Breadcrumbs');
  var breadcrumbsListStyles = (0, _services.useEuiMemoizedStyles)(_breadcrumbs.euiBreadcrumbsListStyles);
  var cssBreadcrumbsListStyles = [breadcrumbsListStyles.euiBreadcrumbs__list, truncate && breadcrumbsListStyles.isTruncated];
  var responsiveMax = useResponsiveMax(responsive, max);
  var visibleBreadcrumbs = (0, _react.useMemo)(function () {
    var shouldCollapseBreadcrumbs = responsiveMax && breadcrumbs.length > responsiveMax;
    return shouldCollapseBreadcrumbs ? limitBreadcrumbs(breadcrumbs, responsiveMax) : breadcrumbs;
  }, [breadcrumbs, responsiveMax]);
  var breadcrumbChildren = (0, _react.useMemo)(function () {
    return visibleBreadcrumbs.map(function (breadcrumb, index) {
      var _breadcrumb$truncate;
      var isFirstBreadcrumb = index === 0;
      var isLastBreadcrumb = index === visibleBreadcrumbs.length - 1;
      var isOnlyBreadcrumb = visibleBreadcrumbs.length === 1;
      var sharedProps = {
        type: type,
        truncate: (_breadcrumb$truncate = breadcrumb.truncate) !== null && _breadcrumb$truncate !== void 0 ? _breadcrumb$truncate : truncate
      };
      return breadcrumb.isCollapsedButton ? (0, _react2.jsx)(_breadcrumb.EuiBreadcrumbCollapsed, (0, _extends2.default)({
        key: "collapsed"
      }, sharedProps, {
        isFirstBreadcrumb: isFirstBreadcrumb
      }), (0, _react2.jsx)(EuiBreadcrumbs, {
        breadcrumbs: breadcrumb.overflowBreadcrumbs,
        lastBreadcrumbIsCurrentPage: false,
        responsive: false,
        truncate: false,
        max: 0
      })) : (0, _react2.jsx)(_breadcrumb.EuiBreadcrumb, (0, _extends2.default)({
        key: index
      }, sharedProps), (0, _react2.jsx)(_breadcrumb_content.EuiBreadcrumbContent, (0, _extends2.default)({}, breadcrumb, sharedProps, {
        isFirstBreadcrumb: isFirstBreadcrumb,
        isLastBreadcrumb: isLastBreadcrumb,
        isOnlyBreadcrumb: isOnlyBreadcrumb,
        highlightLastBreadcrumb: isLastBreadcrumb && lastBreadcrumbIsCurrentPage,
        truncateLastBreadcrumb: isLastBreadcrumb && truncate && breadcrumb.truncate == null
      })));
    });
  }, [visibleBreadcrumbs, truncate, type, lastBreadcrumbIsCurrentPage]);
  return (0, _react2.jsx)("nav", (0, _extends2.default)({
    "aria-label": ariaLabel,
    className: (0, _classnames.default)('euiBreadcrumbs', className)
  }, rest), (0, _react2.jsx)("ol", {
    className: "euiBreadcrumbs__list",
    css: cssBreadcrumbsListStyles
  }, breadcrumbChildren));
};
var useResponsiveMax = exports.useResponsiveMax = function useResponsiveMax(responsive, max) {
  // Use the default object if they simply passed `true` for responsive
  var responsiveObject = (0, _typeof2.default)(responsive) === 'object' ? responsive : responsiveDefault;

  // The max property collapses any breadcrumbs past the max quantity.
  // This is the same behavior we want for responsiveness.
  // So calculate the max value based on the combination of `max` and `responsive`
  var responsiveMax = max;

  // Set the calculated max to the number associated with the currentBreakpoint key if it exists
  var currentBreakpoint = (0, _services.useCurrentEuiBreakpoint)();
  if (responsive && currentBreakpoint && responsiveObject[currentBreakpoint]) {
    responsiveMax = responsiveObject[currentBreakpoint];
  }

  // Final check is to make sure max is used over a larger breakpoint value
  if (max && responsiveMax) {
    responsiveMax = max < responsiveMax ? max : responsiveMax;
  }
  return responsiveMax;
};
var limitBreadcrumbs = exports.limitBreadcrumbs = function limitBreadcrumbs(breadcrumbs, max) {
  var breadcrumbsAtStart = [];
  var breadcrumbsAtEnd = [];
  var limit = Math.min(max, breadcrumbs.length);
  var start = Math.floor(limit / 2);
  var overflowBreadcrumbs = breadcrumbs.slice(start, start + breadcrumbs.length - limit);
  for (var i = 0; i < limit; i++) {
    // We'll alternate with displaying breadcrumbs at the end and at the start, but be biased
    // towards breadcrumbs the end so that if max is an odd number, we'll have one more
    // breadcrumb visible at the end than at the beginning.
    var isEven = i % 2 === 0;

    // We're picking breadcrumbs from the front AND the back, so we treat each iteration as a
    // half-iteration.
    var normalizedIndex = Math.floor(i * 0.5);
    var indexOfBreadcrumb = isEven ? breadcrumbs.length - 1 - normalizedIndex : normalizedIndex;
    var breadcrumb = breadcrumbs[indexOfBreadcrumb];
    if (isEven) {
      breadcrumbsAtEnd.unshift(breadcrumb);
    } else {
      breadcrumbsAtStart.push(breadcrumb);
    }
  }
  return [].concat(breadcrumbsAtStart, [{
    isCollapsedButton: true,
    overflowBreadcrumbs: overflowBreadcrumbs
  }], breadcrumbsAtEnd);
};