"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SIZES = exports.EuiButton = exports.COLORS = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _button = require("../../themes/amsterdam/global_styling/mixins/button");
var _button_display = require("./button_display/_button_display");
var _react2 = require("@emotion/react");
var _excluded = ["className", "buttonRef", "size", "color", "fill"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var COLORS = exports.COLORS = _button.BUTTON_COLORS;
var SIZES = exports.SIZES = ['s', 'm'];

// For some reason, Storybook doesn't parse `EuiButtonDisplayCommonProps` unless we include it here

/**
 * EuiButton is largely responsible for providing relevant props
 * and the logic for element-specific attributes
 */
var EuiButton = exports.EuiButton = function EuiButton(_ref) {
  var className = _ref.className,
    buttonRef = _ref.buttonRef,
    _ref$size = _ref.size,
    size = _ref$size === void 0 ? 'm' : _ref$size,
    _ref$color = _ref.color,
    color = _ref$color === void 0 ? 'primary' : _ref$color,
    fill = _ref.fill,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var isDisabled = (0, _button_display.isButtonDisabled)({
    href: rest.href,
    isDisabled: rest.isDisabled || rest.disabled,
    isLoading: rest.isLoading
  });
  var buttonColorStyles = (0, _button.useEuiButtonColorCSS)({
    display: fill ? 'fill' : 'base'
  })[isDisabled ? 'disabled' : color];
  var buttonFocusStyle = (0, _button.useEuiButtonFocusCSS)();
  var classes = (0, _classnames.default)('euiButton', className);
  var cssStyles = [buttonColorStyles, buttonFocusStyle];
  return (0, _react2.jsx)(_button_display.EuiButtonDisplay, (0, _extends2.default)({
    className: classes,
    css: cssStyles,
    ref: buttonRef,
    size: size
  }, rest));
};