"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiButtonDisplay = void 0;
exports.isButtonDisabled = isButtonDisabled;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _services = require("../../../services");
var _button_display = require("./_button_display.styles");
var _button_display_content = require("./_button_display_content");
var _href_validator = require("../../../services/security/href_validator");
var _excluded = ["element", "type", "children", "iconType", "iconSide", "iconSize", "size", "isDisabled", "disabled", "isLoading", "isSelected", "fullWidth", "minWidth", "contentProps", "textProps", "href", "target", "rel", "style"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
// @ts-ignore module doesn't export `createElement`
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var SIZES = ['xs', 's', 'm'];

/**
 * Extends EuiButtonDisplayContentProps which provides
 * `iconType`, `iconSide`, and `textProps`
 */

function isButtonDisabled(_ref) {
  var href = _ref.href,
    isDisabled = _ref.isDisabled,
    isLoading = _ref.isLoading;
  var isHrefValid = !href || (0, _href_validator.validateHref)(href);
  return isLoading || isDisabled || !isHrefValid;
}

/**
 * EuiButtonDisplay is an internal-only component used for displaying
 * any element as a button.
 */
var EuiButtonDisplay = exports.EuiButtonDisplay = /*#__PURE__*/(0, _react.forwardRef)(function (_ref2, ref) {
  var _ref2$element = _ref2.element,
    _element = _ref2$element === void 0 ? 'button' : _ref2$element,
    _ref2$type = _ref2.type,
    type = _ref2$type === void 0 ? 'button' : _ref2$type,
    children = _ref2.children,
    iconType = _ref2.iconType,
    _ref2$iconSide = _ref2.iconSide,
    iconSide = _ref2$iconSide === void 0 ? 'left' : _ref2$iconSide,
    iconSize = _ref2.iconSize,
    _ref2$size = _ref2.size,
    size = _ref2$size === void 0 ? 'm' : _ref2$size,
    isDisabled = _ref2.isDisabled,
    disabled = _ref2.disabled,
    isLoading = _ref2.isLoading,
    isSelected = _ref2.isSelected,
    fullWidth = _ref2.fullWidth,
    minWidth = _ref2.minWidth,
    contentProps = _ref2.contentProps,
    textProps = _ref2.textProps,
    href = _ref2.href,
    target = _ref2.target,
    rel = _ref2.rel,
    style = _ref2.style,
    rest = (0, _objectWithoutProperties2.default)(_ref2, _excluded);
  var buttonIsDisabled = isButtonDisabled({
    href: href,
    isDisabled: isDisabled || disabled,
    isLoading: isLoading
  });
  var styles = (0, _services.useEuiMemoizedStyles)(_button_display.euiButtonDisplayStyles);
  var cssStyles = [styles.euiButtonDisplay, styles[size], fullWidth && styles.fullWidth, minWidth == null && styles.defaultMinWidth, buttonIsDisabled && styles.isDisabled];
  var innerNode = (0, _react2.jsx)(_button_display_content.EuiButtonDisplayContent, (0, _extends2.default)({
    isLoading: isLoading,
    isDisabled: buttonIsDisabled,
    iconType: iconType,
    iconSide: iconSide,
    iconSize: iconSize,
    textProps: textProps
  }, contentProps), children);
  var element = buttonIsDisabled ? 'button' : href ? 'a' : _element;
  var elementProps = {};
  // Element-specific attributes
  if (element === 'button') {
    elementProps = _objectSpread(_objectSpread({}, elementProps), {}, {
      disabled: buttonIsDisabled,
      'aria-pressed': isSelected
    });
  }
  var relObj = {};
  if (href && !buttonIsDisabled) {
    relObj.href = href;
    relObj.rel = (0, _services.getSecureRelForTarget)({
      href: href,
      target: target,
      rel: rel
    });
    relObj.target = target;
  } else {
    relObj.type = type;
  }
  return (0, _react2.createElement)(element, _objectSpread(_objectSpread(_objectSpread({
    css: cssStyles,
    style: minWidth ? _objectSpread(_objectSpread({}, style), {}, {
      minInlineSize: minWidth
    }) : style,
    ref: ref
  }, elementProps), relObj), rest), innerNode);
});
EuiButtonDisplay.displayName = 'EuiButtonDisplay';