"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ICON_SIZES = exports.ICON_SIDES = exports.EuiButtonDisplayContent = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../../services");
var _loading = require("../../loading");
var _icon = require("../../icon");
var _button_display_content = require("./_button_display_content.styles");
var _react2 = require("@emotion/react");
var _excluded = ["children", "textProps", "isLoading", "isDisabled", "iconType", "iconSize", "iconSide"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var ICON_SIZES = exports.ICON_SIZES = ['s', 'm'];
var ICON_SIDES = exports.ICON_SIDES = ['left', 'right'];

/**
 * *INTERNAL ONLY*
 * This component is simply a helper component for reuse within other button components.
 */

var EuiButtonDisplayContent = exports.EuiButtonDisplayContent = function EuiButtonDisplayContent(_ref) {
  var children = _ref.children,
    textProps = _ref.textProps,
    _ref$isLoading = _ref.isLoading,
    isLoading = _ref$isLoading === void 0 ? false : _ref$isLoading,
    _ref$isDisabled = _ref.isDisabled,
    isDisabled = _ref$isDisabled === void 0 ? false : _ref$isDisabled,
    iconType = _ref.iconType,
    _ref$iconSize = _ref.iconSize,
    iconSize = _ref$iconSize === void 0 ? 'm' : _ref$iconSize,
    _ref$iconSide = _ref.iconSide,
    iconSide = _ref$iconSide === void 0 ? 'left' : _ref$iconSide,
    contentProps = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var styles = (0, _services.useEuiMemoizedStyles)(_button_display_content.euiButtonDisplayContentStyles);

  // Add an icon to the button if one exists.
  var icon = (0, _react.useMemo)(function () {
    if (isLoading) {
      // When the button is disabled the text gets gray
      // and in some buttons the background gets a light gray
      // for better contrast we want to change the border of the spinner
      // to have the same color of the text. This way we ensure the borders
      // are always visible. The default spinner color could be very light.
      var loadingSpinnerColor = isDisabled ? {
        border: 'currentcolor'
      } : undefined;
      return (0, _react2.jsx)(_loading.EuiLoadingSpinner, {
        size: iconSize,
        color: loadingSpinnerColor
      });
    }
    if (iconType) {
      return (0, _react2.jsx)(_icon.EuiIcon, {
        type: iconType,
        size: iconSize,
        color: "inherit" // forces the icon to inherit its parent color
      });
    }
  }, [iconType, iconSize, isLoading, isDisabled]);
  var isText = typeof children === 'string';
  var doNotRenderTextWrapper = textProps === false;
  var renderTextWrapper = (isText || textProps) && !doNotRenderTextWrapper;
  return (0, _react2.jsx)("span", (0, _extends2.default)({
    css: styles.euiButtonDisplayContent
  }, contentProps), iconSide === 'left' && icon, renderTextWrapper ? (0, _react2.jsx)("span", (0, _extends2.default)({}, textProps, {
    className: (0, _classnames.default)('eui-textTruncate', textProps === null || textProps === void 0 ? void 0 : textProps.className)
  }), children) : children, iconSide === 'right' && icon);
};