"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SIZES = exports.FLUSH_TYPES = exports.EuiButtonEmpty = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../../services");
var _button_display_content = require("../button_display/_button_display_content");
var _button = require("../../../themes/amsterdam/global_styling/mixins/button");
var _button_display = require("../button_display/_button_display");
var _button_empty = require("./button_empty.styles");
var _react2 = require("@emotion/react");
var _excluded = ["children", "className", "iconType", "iconSide", "iconSize", "color", "size", "flush", "isDisabled", "disabled", "isLoading", "href", "target", "rel", "type", "buttonRef", "contentProps", "textProps", "isSelected"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var SIZES = exports.SIZES = ['xs', 's', 'm'];
var FLUSH_TYPES = exports.FLUSH_TYPES = ['left', 'right', 'both'];

/**
 * Extends EuiButtonContentProps which provides
 * `iconType`, `iconSide`, and `textProps`
 */

var EuiButtonEmpty = exports.EuiButtonEmpty = function EuiButtonEmpty(_ref) {
  var children = _ref.children,
    className = _ref.className,
    iconType = _ref.iconType,
    _ref$iconSide = _ref.iconSide,
    iconSide = _ref$iconSide === void 0 ? 'left' : _ref$iconSide,
    _ref$iconSize = _ref.iconSize,
    iconSize = _ref$iconSize === void 0 ? 'm' : _ref$iconSize,
    _ref$color = _ref.color,
    color = _ref$color === void 0 ? 'primary' : _ref$color,
    _ref$size = _ref.size,
    size = _ref$size === void 0 ? 'm' : _ref$size,
    flush = _ref.flush,
    _isDisabled = _ref.isDisabled,
    disabled = _ref.disabled,
    isLoading = _ref.isLoading,
    href = _ref.href,
    target = _ref.target,
    rel = _ref.rel,
    _ref$type = _ref.type,
    type = _ref$type === void 0 ? 'button' : _ref$type,
    buttonRef = _ref.buttonRef,
    contentProps = _ref.contentProps,
    textProps = _ref.textProps,
    isSelected = _ref.isSelected,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var isDisabled = (0, _button_display.isButtonDisabled)({
    isDisabled: _isDisabled || disabled,
    href: href,
    isLoading: isLoading
  });
  var buttonColorStyles = (0, _button.useEuiButtonColorCSS)({
    display: 'empty'
  });
  var styles = (0, _services.useEuiMemoizedStyles)(_button_empty.euiButtonEmptyStyles);
  var cssStyles = [styles.euiButtonEmpty, styles[size], buttonColorStyles[isDisabled ? 'disabled' : color], flush && styles.flush, flush && styles[flush], isDisabled && styles.isDisabled];
  var classes = (0, _classnames.default)('euiButtonEmpty', className);
  var contentClassNames = (0, _classnames.default)('euiButtonEmpty__content', contentProps === null || contentProps === void 0 ? void 0 : contentProps.className);
  var textClassNames = (0, _classnames.default)('euiButtonEmpty__text', textProps && textProps.className);
  var innerNode = (0, _react2.jsx)(_button_display_content.EuiButtonDisplayContent, (0, _extends2.default)({
    isDisabled: isDisabled,
    isLoading: isLoading,
    iconType: iconType,
    iconSide: iconSide,
    iconSize: size === 'xs' ? 's' : iconSize,
    textProps: textProps === false ? false : _objectSpread(_objectSpread({}, textProps), {}, {
      className: textClassNames
    })
  }, _objectSpread(_objectSpread({}, contentProps), {}, {
    className: contentClassNames
  })), children);

  // <a> elements don't respect the `disabled` attribute. So if we're disabled, we'll just pretend
  // this is a button and piggyback off its disabled styles.
  if (href && !isDisabled) {
    var secureRel = (0, _services.getSecureRelForTarget)({
      href: href,
      target: target,
      rel: rel
    });
    return (0, _react2.jsx)("a", (0, _extends2.default)({
      className: classes,
      css: cssStyles,
      href: href,
      target: target,
      rel: secureRel,
      ref: buttonRef
    }, rest), innerNode);
  }
  return (0, _react2.jsx)("button", (0, _extends2.default)({
    disabled: isDisabled,
    className: classes,
    css: cssStyles,
    type: type,
    ref: buttonRef,
    "aria-pressed": isSelected
  }, rest), innerNode);
};