"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiButtonGroup = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _classnames = _interopRequireDefault(require("classnames"));
var _react = _interopRequireDefault(require("react"));
var _services = require("../../../services");
var _accessibility = require("../../accessibility");
var _button_group_button = require("./button_group_button");
var _button_group = require("./button_group.styles");
var _react2 = require("@emotion/react");
var _excluded = ["className", "buttonSize", "color", "idSelected", "idToSelectedMap", "isDisabled", "isFullWidth", "isIconOnly", "legend", "name", "onChange", "options", "type"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var EuiButtonGroup = exports.EuiButtonGroup = function EuiButtonGroup(_ref) {
  var className = _ref.className,
    _ref$buttonSize = _ref.buttonSize,
    buttonSize = _ref$buttonSize === void 0 ? 's' : _ref$buttonSize,
    _ref$color = _ref.color,
    color = _ref$color === void 0 ? 'text' : _ref$color,
    _ref$idSelected = _ref.idSelected,
    idSelected = _ref$idSelected === void 0 ? '' : _ref$idSelected,
    _ref$idToSelectedMap = _ref.idToSelectedMap,
    idToSelectedMap = _ref$idToSelectedMap === void 0 ? {} : _ref$idToSelectedMap,
    _ref$isDisabled = _ref.isDisabled,
    isDisabled = _ref$isDisabled === void 0 ? false : _ref$isDisabled,
    _ref$isFullWidth = _ref.isFullWidth,
    isFullWidth = _ref$isFullWidth === void 0 ? false : _ref$isFullWidth,
    _ref$isIconOnly = _ref.isIconOnly,
    isIconOnly = _ref$isIconOnly === void 0 ? false : _ref$isIconOnly,
    legend = _ref.legend,
    name = _ref.name,
    onChange = _ref.onChange,
    _ref$options = _ref.options,
    options = _ref$options === void 0 ? [] : _ref$options,
    _ref$type = _ref.type,
    type = _ref$type === void 0 ? 'single' : _ref$type,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var wrapperCssStyles = [_button_group.euiButtonGroupStyles.euiButtonGroup, isFullWidth && _button_group.euiButtonGroupStyles.fullWidth];
  var styles = (0, _services.useEuiMemoizedStyles)(_button_group.euiButtonGroupButtonsStyles);
  var cssStyles = [styles.euiButtonGroup__buttons, isFullWidth && styles.fullWidth, styles[buttonSize]];
  var classes = (0, _classnames.default)('euiButtonGroup', {
    'euiButtonGroup-isDisabled': isDisabled
  }, className);
  var typeIsSingle = type === 'single';
  return (0, _react2.jsx)("fieldset", (0, _extends2.default)({
    css: wrapperCssStyles,
    className: classes
  }, rest, {
    disabled: isDisabled
  }), (0, _react2.jsx)(_accessibility.EuiScreenReaderOnly, null, (0, _react2.jsx)("legend", null, legend)), (0, _react2.jsx)("div", {
    css: cssStyles,
    className: "euiButtonGroup__buttons"
  }, options.map(function (option) {
    return (0, _react2.jsx)(_button_group_button.EuiButtonGroupButton, (0, _extends2.default)({
      key: option.id,
      isDisabled: isDisabled
    }, option, {
      onClick: typeIsSingle ? function () {
        return onChange(option.id, option.value);
      } : function () {
        return onChange(option.id);
      },
      isSelected: typeIsSingle ? option.id === idSelected : idToSelectedMap[option.id],
      color: color,
      size: buttonSize,
      isIconOnly: isIconOnly
    }));
  })));
};