"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HEADINGS = exports.EuiCallOut = exports.COLORS = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _icon = require("../icon");
var _button = require("../button");
var _text = require("../text");
var _panel = require("../panel");
var _spacer = require("../spacer");
var _title = require("../title");
var _i18n = require("../i18n");
var _call_out = require("./call_out.styles");
var _react2 = require("@emotion/react");
var _excluded = ["title", "color", "size", "iconType", "children", "className", "heading", "onDismiss"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var COLORS = exports.COLORS = ['primary', 'success', 'warning', 'danger'];
var HEADINGS = exports.HEADINGS = ['h1', 'h2', 'h3', 'h4', 'h5', 'h6', 'p'];
var EuiCallOut = exports.EuiCallOut = /*#__PURE__*/(0, _react.forwardRef)(function (_ref, ref) {
  var title = _ref.title,
    _ref$color = _ref.color,
    color = _ref$color === void 0 ? 'primary' : _ref$color,
    _ref$size = _ref.size,
    size = _ref$size === void 0 ? 'm' : _ref$size,
    iconType = _ref.iconType,
    children = _ref.children,
    className = _ref.className,
    _ref$heading = _ref.heading,
    heading = _ref$heading === void 0 ? 'p' : _ref$heading,
    onDismiss = _ref.onDismiss,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var styles = (0, _services.useEuiMemoizedStyles)(_call_out.euiCallOutStyles);
  var cssStyles = [styles.euiCallOut, onDismiss && styles.hasDismissButton.hasDimissButton, onDismiss && styles.hasDismissButton[size]];
  var classes = (0, _classnames.default)('euiCallOut', (0, _defineProperty2.default)({}, "euiCallOut--".concat(color), color), className);
  var dismissButton = (0, _react.useMemo)(function () {
    if (!onDismiss) return;
    var cssStyles = [styles.dismissButton.euiCallOut__dismissButton, styles.dismissButton[size]];
    return (0, _react2.jsx)(_i18n.EuiI18n, {
      token: "euiCallOut.dismissAriaLabel",
      default: "Dismiss this callout"
    }, function (dismissAriaLabel) {
      return (0, _react2.jsx)(_button.EuiButtonIcon, {
        iconType: "cross",
        onClick: onDismiss,
        "aria-label": dismissAriaLabel,
        css: cssStyles,
        color: color,
        "data-test-subj": "euiDismissCalloutButton"
      });
    });
  }, [onDismiss, styles, color, size]);
  var headerStyles = (0, _services.useEuiMemoizedStyles)(_call_out.euiCallOutHeaderStyles);
  var header = (0, _react.useMemo)(function () {
    if (!title) return;
    var H = heading;
    var cssStyles = [headerStyles.euiCallOutHeader, headerStyles[color]];
    return (0, _react2.jsx)(_title.EuiTitle, {
      size: size === 's' ? 'xxs' : 'xs',
      css: cssStyles
    }, (0, _react2.jsx)(H, {
      className: "euiCallOutHeader__title"
    }, iconType && (0, _react2.jsx)(_icon.EuiIcon, {
      css: headerStyles.euiCallOut__icon,
      type: iconType,
      size: "m",
      "aria-hidden": "true",
      color: "inherit"
    }), title));
  }, [title, heading, iconType, size, color, headerStyles]);
  var optionalChildren = children && (0, _react2.jsx)(_text.EuiText, {
    size: size === 's' ? 'xs' : 's',
    color: "default"
  }, children);
  return (0, _react2.jsx)(_panel.EuiPanel, (0, _extends2.default)({
    borderRadius: "none",
    color: color,
    css: cssStyles,
    paddingSize: size === 's' ? 's' : 'm',
    className: classes,
    panelRef: ref,
    grow: false
  }, rest),
  // Note: the DOM position of the dismiss button matters to screen reader users.
  // We generally want them to have some context of _what_ they're dismissing,
  // instead of navigating to the dismiss button first before the callout content
  header && optionalChildren ? (0, _react2.jsx)(_react.default.Fragment, null, header, dismissButton, (0, _react2.jsx)(_spacer.EuiSpacer, {
    size: "s"
  }), optionalChildren) : (0, _react2.jsx)(_react.default.Fragment, null, header || optionalChildren, dismissButton));
});
EuiCallOut.displayName = 'EuiCallOut';