"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiCard = exports.ALIGNMENTS = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _accessibility = require("../../services/accessibility");
var _href_validator = require("../../services/security/href_validator");
var _text = require("../text");
var _title = require("../title");
var _beta_badge = require("../badge/beta_badge");
var _panel = require("../panel");
var _spacer = require("../spacer");
var _card_select = require("./card_select");
var _card = require("./card.styles");
var _react2 = require("@emotion/react");
var _excluded = ["className", "description", "isDisabled", "title", "titleElement", "titleSize", "icon", "image", "children", "footer", "onClick", "href", "rel", "target", "textAlign", "betaBadgeProps", "layout", "selectable", "display", "paddingSize"],
  _excluded2 = ["anchorProps"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var ALIGNMENTS = exports.ALIGNMENTS = ['left', 'center', 'right'];

/**
 * Certain props are only allowed when the layout is vertical
 */

var EuiCard = exports.EuiCard = function EuiCard(_ref) {
  var className = _ref.className,
    description = _ref.description,
    _isDisabled = _ref.isDisabled,
    title = _ref.title,
    _ref$titleElement = _ref.titleElement,
    titleElement = _ref$titleElement === void 0 ? 'p' : _ref$titleElement,
    _ref$titleSize = _ref.titleSize,
    titleSize = _ref$titleSize === void 0 ? 's' : _ref$titleSize,
    icon = _ref.icon,
    image = _ref.image,
    children = _ref.children,
    footer = _ref.footer,
    onClick = _ref.onClick,
    href = _ref.href,
    rel = _ref.rel,
    target = _ref.target,
    _ref$textAlign = _ref.textAlign,
    textAlign = _ref$textAlign === void 0 ? 'center' : _ref$textAlign,
    betaBadgeProps = _ref.betaBadgeProps,
    _ref$layout = _ref.layout,
    layout = _ref$layout === void 0 ? 'vertical' : _ref$layout,
    selectable = _ref.selectable,
    display = _ref.display,
    _ref$paddingSize = _ref.paddingSize,
    paddingSize = _ref$paddingSize === void 0 ? 'm' : _ref$paddingSize,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var isHrefValid = !href || (0, _href_validator.validateHref)(href);
  var isDisabled = _isDisabled || !isHrefValid;
  var isClickable = !isDisabled && (onClick || href || selectable && !selectable.isDisabled);
  var euiThemeContext = (0, _services.useEuiTheme)();
  var styles = (0, _card.euiCardStyles)(euiThemeContext, paddingSize);
  var cardStyles = [styles.card.euiCard,
  // Text alignment should always be left when horizontal
  styles.card.aligned[layout === 'horizontal' ? 'left' : textAlign], isDisabled && styles.card.disabled];
  var contentStyles = [styles.content.euiCard__content, styles.content.layout[layout]];
  var mainStyles = [styles.main.euiCard__main, styles.main.layout[layout]];
  var textStyles = (0, _card.euiCardTextStyles)(euiThemeContext);
  var textCSS = [textStyles.euiCard__text,
  // Text alignment should always be left when horizontal
  textStyles.aligned[layout === 'horizontal' ? 'left' : textAlign], isClickable && textStyles.interactive, isDisabled && textStyles.disabled];

  /**
   * For a11y, we simulate the same click that's provided on the title when clicking the whole card
   * without having to make the whole card a button or anchor tag.
   * *Card Accessibility: The redundant click event https://inclusive-components.design/cards/*
   */
  var link = null;
  var outerOnClick = function outerOnClick(e) {
    if (link && link !== e.target && !link.contains(e.target)) {
      link.click();
    }
  };
  if (layout === 'horizontal') {
    if (image || footer || textAlign !== 'center') {
      throw new Error('EuiCard: `layout="horizontal"` cannot be used in conjunction with `image`, `footer`, or `textAlign`.');
    }
  }
  var classes = (0, _classnames.default)('euiCard', className);
  var ariaId = (0, _accessibility.useGeneratedHtmlId)();
  var ariaDesc = description ? "".concat(ariaId, "Description") : '';

  /**
   * Top area containing image, icon or both
   */

  var imageNode;
  if (image && layout === 'vertical') {
    if ( /*#__PURE__*/(0, _react.isValidElement)(image) || typeof image === 'string') {
      var imageStyles = [styles.image.euiCard__image, display === 'transparent' && styles.image.transparent];
      imageNode = (0, _react2.jsx)("div", {
        className: "euiCard__image",
        css: imageStyles
      }, /*#__PURE__*/(0, _react.isValidElement)(image) ? image : (0, _react2.jsx)("img", {
        src: image,
        alt: ""
      }));
    } else {
      imageNode = null;
    }
  }
  var iconNode;
  if (icon) {
    var iconStyles = [styles.icon.euiCard__icon, styles.icon.layout[layout], imageNode && styles.icon.withImage];
    iconNode = (0, _services.cloneElementWithCss)(icon, {
      className: (0, _classnames.default)(icon.props.className, 'euiCard__icon'),
      css: iconStyles
    });
  }
  var optionalCardTop;
  if (imageNode || iconNode) {
    var topStyles = [styles.top.euiCard__top, styles.top.layout[layout], isDisabled && styles.top.disabled];
    optionalCardTop = (0, _react2.jsx)("div", {
      className: "euiCard__top",
      css: topStyles
    }, imageNode, iconNode);
  }

  /**
   * Optional EuiBetaBadge
   */

  var optionalBetaBadge;
  var optionalBetaBadgeID = '';
  var optionalBetaCSS;
  if (betaBadgeProps !== null && betaBadgeProps !== void 0 && betaBadgeProps.label) {
    var betaStyles = (0, _card.euiCardBetaBadgeStyles)(euiThemeContext, paddingSize);
    optionalBetaCSS = betaStyles.hasBetaBadge;
    var anchorProps = betaBadgeProps.anchorProps,
      cleanedBetaBadgeProps = (0, _objectWithoutProperties2.default)(betaBadgeProps, _excluded2);
    var anchorCSS = [betaStyles.euiCard__betaBadgeAnchor, anchorProps === null || anchorProps === void 0 ? void 0 : anchorProps.css];
    var badgeCSS = [betaStyles.euiCard__betaBadge, betaBadgeProps === null || betaBadgeProps === void 0 ? void 0 : betaBadgeProps.css];
    optionalBetaBadgeID = "".concat(ariaId, "BetaBadge");
    optionalBetaBadge = (0, _react2.jsx)(_beta_badge.EuiBetaBadge, (0, _extends2.default)({
      color: isDisabled && !betaBadgeProps.onClick && !betaBadgeProps.href ? 'subdued' : 'hollow'
    }, cleanedBetaBadgeProps, {
      css: badgeCSS,
      anchorProps: _objectSpread(_objectSpread({}, anchorProps), {}, {
        css: anchorCSS
      }),
      id: optionalBetaBadgeID
    }));

    // Increase padding size when there is a beta badge unless it's already determined
    // paddingSize = paddingSize || 'l';
  }

  /**
   * Optional selectable button
   */

  if (selectable && isDisabled && selectable.isDisabled === undefined) {
    selectable.isDisabled = isDisabled;
  }
  var optionalSelectButton;
  if (selectable) {
    optionalSelectButton = (0, _react2.jsx)(_react.default.Fragment, null, paddingSize !== 'none' && (0, _react2.jsx)(_spacer.EuiSpacer, {
      size: paddingSize || 'm'
    }), (0, _react2.jsx)(_card_select.EuiCardSelect, (0, _extends2.default)({
      "aria-describedby": "".concat(ariaId, "Title ").concat(ariaDesc)
    }, selectable, {
      buttonRef: function buttonRef(node) {
        link = node;
      }
    })));
  }
  var TitleElement = titleElement;

  /**
   * Wraps the title with the link (<a>) or button.
   * This makes the title element a11y friendly and gets described by its content if its interactable.
   */

  var theTitle;
  if (!isDisabled && href) {
    theTitle = (0, _react2.jsx)("a", {
      className: "euiCard__titleAnchor",
      css: textCSS,
      onClick: onClick,
      href: href,
      target: target,
      "aria-describedby": ariaDesc,
      rel: (0, _services.getSecureRelForTarget)({
        href: href,
        target: target,
        rel: rel
      }),
      ref: function ref(node) {
        link = node;
      }
    }, title);
  } else if (isDisabled || onClick) {
    theTitle = (0, _react2.jsx)("button", {
      className: "euiCard__titleButton",
      css: textCSS,
      onClick: onClick,
      disabled: isDisabled,
      "aria-describedby": "".concat(optionalBetaBadgeID, " ").concat(ariaDesc),
      ref: function ref(node) {
        link = node;
      }
    }, title);
  } else {
    theTitle = (0, _react2.jsx)("span", {
      css: textCSS
    }, title);
  }

  /**
   * Children and/or Description content
   */
  var optionalChildren;
  if (children) {
    var childrenStyles = [styles.euiCard__children];
    optionalChildren = (0, _react2.jsx)("div", {
      css: childrenStyles
    }, children);
  }
  var optionalDescription;
  if (description) {
    var descriptionStyles = [styles.euiCard__description];
    optionalDescription = (0, _react2.jsx)(_text.EuiText, {
      id: ariaDesc,
      size: "s",
      css: descriptionStyles
    }, (0, _react2.jsx)("p", null, description));
  }

  /**
   * Footer content
   */
  var optionalFooter;
  if (layout === 'vertical' && footer) {
    var footerStyles = [styles.euiCard__footer];
    optionalFooter = (0, _react2.jsx)("div", {
      css: footerStyles
    }, footer);
  }
  return (0, _react2.jsx)(_panel.EuiPanel, (0, _extends2.default)({
    element: "div",
    className: classes,
    css: [].concat(cardStyles, [optionalBetaCSS]),
    onClick: isClickable ? outerOnClick : undefined,
    color: isDisabled ? 'subdued' : display,
    hasShadow: isDisabled || display ? false : true,
    hasBorder: display ? false : undefined,
    paddingSize: paddingSize
  }, rest), (0, _react2.jsx)("div", {
    className: "euiCard__main",
    css: mainStyles
  }, optionalCardTop, (0, _react2.jsx)("div", {
    className: "euiCard__content",
    css: contentStyles
  }, (0, _react2.jsx)(_title.EuiTitle, {
    id: "".concat(ariaId, "Title"),
    className: "euiCard__title",
    size: titleSize
  }, (0, _react2.jsx)(TitleElement, null, theTitle)), optionalDescription, optionalChildren), optionalBetaBadge, optionalFooter), optionalSelectButton);
};