"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiCardSelect = void 0;
exports.euiCardSelectableColor = euiCardSelectableColor;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireDefault(require("react"));
var _i18n = require("../../i18n");
var _button = require("../../button/button");
var _card_select = require("./card_select.styles");
var _react2 = require("@emotion/react");
var _excluded = ["isSelected", "isDisabled", "disabled", "color", "children"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var EuiCardSelect = exports.EuiCardSelect = function EuiCardSelect(_ref) {
  var _ref$isSelected = _ref.isSelected,
    isSelected = _ref$isSelected === void 0 ? false : _ref$isSelected,
    isDisabled = _ref.isDisabled,
    disabled = _ref.disabled,
    color = _ref.color,
    children = _ref.children,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var styles = (0, _card_select.euiCardSelectStyles)();
  var baseCSS = [styles.euiCardSelect];
  var child = euiCardSelectableText(isSelected, isDisabled || disabled, children);
  return (0, _react2.jsx)(_button.EuiButton, (0, _extends2.default)({
    css: baseCSS,
    color: euiCardSelectableColor(color, isSelected),
    size: "m",
    isDisabled: isDisabled || disabled,
    iconType: isSelected ? 'check' : undefined,
    role: "switch",
    "aria-checked": isSelected,
    fullWidth: true
  }, rest), child);
};
function euiCardSelectableText(isSelected, isDisabled, children) {
  if (children) {
    return children;
  }
  var text;
  if (isSelected) {
    text = (0, _react2.jsx)(_i18n.EuiI18n, {
      token: "euiCardSelect.selected",
      default: "Selected"
    });
  } else if (isDisabled) {
    text = (0, _react2.jsx)(_i18n.EuiI18n, {
      token: "euiCardSelect.unavailable",
      default: "Unavailable"
    });
  } else {
    text = (0, _react2.jsx)(_i18n.EuiI18n, {
      token: "euiCardSelect.select",
      default: "Select"
    });
  }
  return text;
}
function euiCardSelectableColor(color, isSelected) {
  var calculatedColor;
  if (color) {
    calculatedColor = color;
  } else if (isSelected) {
    calculatedColor = 'success';
  } else {
    calculatedColor = 'text';
  }
  return calculatedColor;
}