"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiCheckableCard = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _form = require("../../form");
var _panel = require("../../panel");
var _services = require("../../../services");
var _checkable_card = require("./checkable_card.styles");
var _react2 = require("@emotion/react");
var _excluded = ["children", "className", "css", "checkableType", "label", "checked", "disabled", "hasShadow", "hasBorder"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
// if `checkableType` is left out or set to 'radio', use EuiRadioProps
// if `checkableType` is set to 'checkbox', use EuiCheckboxProps
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var EuiCheckableCard = exports.EuiCheckableCard = function EuiCheckableCard(_ref) {
  var children = _ref.children,
    className = _ref.className,
    css = _ref.css,
    _ref$checkableType = _ref.checkableType,
    checkableType = _ref$checkableType === void 0 ? 'radio' : _ref$checkableType,
    label = _ref.label,
    checked = _ref.checked,
    disabled = _ref.disabled,
    hasShadow = _ref.hasShadow,
    _ref$hasBorder = _ref.hasBorder,
    hasBorder = _ref$hasBorder === void 0 ? true : _ref$hasBorder,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var euiThemeContext = (0, _services.useEuiTheme)();
  var styles = (0, _checkable_card.euiCheckableCardStyles)(euiThemeContext);
  var baseStyles = [styles.euiCheckableCard, checked && !disabled && styles.isChecked, css];
  var labelStyles = [styles.label.euiCheckableCard__label, disabled && styles.label.isDisabled];
  var childStyles = [styles.euiCheckableCard__children];
  var id = rest.id;
  var labelEl = (0, _react.useRef)(null);
  var classes = (0, _classnames.default)('euiCheckableCard', className);
  var checkableElement;
  if (checkableType === 'radio') {
    checkableElement = (0, _react2.jsx)(_form.EuiRadio, (0, _extends2.default)({
      checked: checked,
      disabled: disabled
    }, rest));
  } else {
    checkableElement = (0, _react2.jsx)(_form.EuiCheckbox, (0, _extends2.default)({
      checked: checked,
      disabled: disabled
    }, rest));
  }
  var labelClasses = (0, _classnames.default)('euiCheckableCard__label');
  var onChangeAffordance = function onChangeAffordance() {
    if (labelEl.current) {
      labelEl.current.click();
    }
  };
  return (0, _react2.jsx)(_panel.EuiSplitPanel.Outer, {
    responsive: false,
    hasShadow: hasShadow,
    hasBorder: hasBorder,
    direction: "row",
    className: classes,
    css: baseStyles
  }, (0, _react2.jsx)(_panel.EuiSplitPanel.Inner, {
    // Bubbles up the change event when clicking on the whole div for extra affordance
    onClick: disabled ? undefined : onChangeAffordance,
    color: checked ? 'primary' : 'subdued',
    grow: false
  }, checkableElement), (0, _react2.jsx)(_panel.EuiSplitPanel.Inner, null, (0, _react2.jsx)("label", {
    ref: labelEl,
    className: labelClasses,
    css: labelStyles,
    htmlFor: id,
    "aria-describedby": children ? "".concat(id, "-details") : undefined
  }, label), children && (0, _react2.jsx)("div", {
    id: "".concat(id, "-details"),
    className: "euiCheckableCard__children",
    css: childStyles
  }, children)));
};