"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiCode = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireWildcard(require("react"));
var _refractor = require("refractor");
var _classnames = _interopRequireDefault(require("classnames"));
var _utils = require("./utils");
var _services = require("../../services");
var _code = require("./code.styles");
var _react2 = require("@emotion/react");
var _excluded = ["transparentBackground", "language", "children", "className"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var EuiCode = exports.EuiCode = function EuiCode(_ref) {
  var _ref$transparentBackg = _ref.transparentBackground,
    transparentBackground = _ref$transparentBackg === void 0 ? false : _ref$transparentBackg,
    _ref$language = _ref.language,
    _language = _ref$language === void 0 ? _utils.DEFAULT_LANGUAGE : _ref$language,
    children = _ref.children,
    className = _ref.className,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var language = (0, _react.useMemo)(function () {
    return (0, _utils.checkSupportedLanguage)(_language);
  }, [_language]);
  var data = (0, _react.useMemo)(function () {
    if (typeof children !== 'string') {
      return [];
    }
    return (0, _refractor.highlight)(children, language);
  }, [children, language]);
  var content = (0, _react.useMemo)(function () {
    return (0, _utils.getHtmlContent)(data, children);
  }, [data, children]);
  var classes = (0, _classnames.default)('euiCode', className);
  var styles = (0, _services.useEuiMemoizedStyles)(_code.euiCodeStyles);
  var cssStyles = [styles.euiCode, transparentBackground && styles.transparentBackground];
  return (0, _react2.jsx)("code", (0, _extends2.default)({
    className: classes,
    css: cssStyles,
    "data-code-language": language
  }, rest), content);
};