"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof3 = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PADDING_SIZES = exports.FONT_SIZES = exports.EuiCodeBlock = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _typeof2 = _interopRequireDefault(require("@babel/runtime/helpers/typeof"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _utils = require("./utils");
var _code_block_overflow = require("./code_block_overflow");
var _code_block_copy = require("./code_block_copy");
var _code_block_full_screen = require("./code_block_full_screen");
var _code_block_controls = require("./code_block_controls");
var _code_block_virtualized = require("./code_block_virtualized");
var _code_block = require("./code_block.styles");
var _accessibility = require("../accessibility");
var _i18n = require("../i18n");
var _react2 = require("@emotion/react");
var _excluded = ["language", "transparentBackground", "paddingSize", "fontSize", "isCopyable", "copyAriaLabel", "whiteSpace", "children", "className", "overflowHeight", "isVirtualized", "lineNumbers"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
// Based on observed line height for non-virtualized code blocks
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof3(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var fontSizeToRowHeightMap = {
  s: 18,
  m: 21,
  l: 24
};
var FONT_SIZES = exports.FONT_SIZES = ['s', 'm', 'l'];
var PADDING_SIZES = exports.PADDING_SIZES = ['none', 's', 'm', 'l'];

// This exclusive union enforces specific props based on isVirtualized

var EuiCodeBlock = exports.EuiCodeBlock = function EuiCodeBlock(_ref) {
  var _ref$language = _ref.language,
    _language = _ref$language === void 0 ? _utils.DEFAULT_LANGUAGE : _ref$language,
    _ref$transparentBackg = _ref.transparentBackground,
    transparentBackground = _ref$transparentBackg === void 0 ? false : _ref$transparentBackg,
    _ref$paddingSize = _ref.paddingSize,
    paddingSize = _ref$paddingSize === void 0 ? 'l' : _ref$paddingSize,
    _ref$fontSize = _ref.fontSize,
    fontSize = _ref$fontSize === void 0 ? 's' : _ref$fontSize,
    _ref$isCopyable = _ref.isCopyable,
    isCopyable = _ref$isCopyable === void 0 ? false : _ref$isCopyable,
    copyAriaLabel = _ref.copyAriaLabel,
    _ref$whiteSpace = _ref.whiteSpace,
    whiteSpace = _ref$whiteSpace === void 0 ? 'pre-wrap' : _ref$whiteSpace,
    children = _ref.children,
    className = _ref.className,
    overflowHeight = _ref.overflowHeight,
    _isVirtualized = _ref.isVirtualized,
    _ref$lineNumbers = _ref.lineNumbers,
    lineNumbers = _ref$lineNumbers === void 0 ? false : _ref$lineNumbers,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var euiTheme = (0, _services.useEuiTheme)();
  var language = (0, _react.useMemo)(function () {
    return (0, _utils.checkSupportedLanguage)(_language);
  }, [_language]);
  var lineNumbersConfig = (0, _react.useMemo)(function () {
    var config = (0, _typeof2.default)(lineNumbers) === 'object' ? lineNumbers : {};
    return lineNumbers ? _objectSpread({
      start: 1,
      show: true
    }, config) : {
      start: 1,
      show: false
    };
  }, [lineNumbers]);

  // Used by `FixedSizeList` when `isVirtualized=true` or `children` is parsable
  var data = (0, _react.useMemo)(function () {
    if (typeof children !== 'string') {
      return [];
    }
    return (0, _utils.highlightByLine)(children, language, lineNumbersConfig, euiTheme);
  }, [children, language, lineNumbersConfig, euiTheme]);

  // Used by `pre` when `isVirtualized=false` or `children` is not parsable
  var content = (0, _react.useMemo)(function () {
    return (0, _utils.getHtmlContent)(data, children);
  }, [data, children]);
  var isVirtualized = (0, _react.useMemo)(function () {
    return !!(_isVirtualized && Array.isArray(data));
  }, [_isVirtualized, data]);
  var _useCopy = (0, _code_block_copy.useCopy)({
      copyAriaLabel: copyAriaLabel,
      isCopyable: isCopyable,
      isVirtualized: isVirtualized,
      children: children
    }),
    innerTextRef = _useCopy.innerTextRef,
    copyButton = _useCopy.copyButton;
  var _useOverflow = (0, _code_block_overflow.useOverflow)({
      overflowHeight: overflowHeight
    }),
    setWrapperRef = _useOverflow.setWrapperRef,
    tabIndex = _useOverflow.tabIndex,
    overflowHeightStyles = _useOverflow.overflowHeightStyles;
  var combinedRef = (0, _services.useCombinedRefs)([innerTextRef, setWrapperRef]);
  var _useFullScreen = (0, _code_block_full_screen.useFullScreen)({
      overflowHeight: overflowHeight
    }),
    fullScreenButton = _useFullScreen.fullScreenButton,
    isFullScreen = _useFullScreen.isFullScreen,
    onKeyDown = _useFullScreen.onKeyDown;
  var hasControls = !!(copyButton || fullScreenButton);
  var hasBothControls = !!(copyButton && fullScreenButton);
  var styles = (0, _services.useEuiMemoizedStyles)(_code_block.euiCodeBlockStyles);
  var cssStyles = [styles.euiCodeBlock, styles[fontSize], transparentBackground && styles.transparentBackground, hasControls && (hasBothControls ? styles.hasBothControls[paddingSize] : styles.hasControls[paddingSize])];
  var preStyles = (0, _services.useEuiMemoizedStyles)(_code_block.euiCodeBlockPreStyles);
  var _useMemo = (0, _react.useMemo)(function () {
      var isWhiteSpacePre = whiteSpace === 'pre' || isVirtualized;
      var cssStyles = [preStyles.euiCodeBlock__pre, isWhiteSpacePre ? preStyles.whiteSpace.pre.pre : preStyles.whiteSpace.preWrap.preWrap];
      var preProps = {
        className: 'euiCodeBlock__pre',
        css: [].concat(cssStyles, [preStyles.padding[paddingSize], hasControls && (isWhiteSpacePre ? preStyles.whiteSpace.pre.controlsOffset[paddingSize] : preStyles.whiteSpace.preWrap.controlsOffset[paddingSize])]),
        tabIndex: isVirtualized ? 0 : tabIndex
      };
      var preFullscreenProps = {
        className: 'euiCodeBlock__pre',
        css: [].concat(cssStyles, [
        // Force fullscreen to use xl padding
        preStyles.padding.xl, hasControls && (isWhiteSpacePre ? preStyles.whiteSpace.pre.controlsOffset.xl : preStyles.whiteSpace.preWrap.controlsOffset.xl)]),
        tabIndex: 0
      };
      return [preProps, preFullscreenProps];
    }, [preStyles, whiteSpace, isVirtualized, hasControls, paddingSize, tabIndex]),
    _useMemo2 = (0, _slicedToArray2.default)(_useMemo, 2),
    preProps = _useMemo2[0],
    preFullscreenProps = _useMemo2[1];
  var codeStyles = (0, _services.useEuiMemoizedStyles)(_code_block.euiCodeBlockCodeStyles);
  var codeProps = (0, _react.useMemo)(function () {
    var cssStyles = [codeStyles.euiCodeBlock__code, isVirtualized && codeStyles.isVirtualized];
    return _objectSpread({
      className: 'euiCodeBlock__code',
      css: cssStyles,
      'data-code-language': language
    }, rest);
  }, [codeStyles, language, isVirtualized, rest]);
  var codeBlockLabel = (0, _i18n.useEuiI18n)('euiCodeBlock.label', '{language} code block:', {
    language: language
  });
  // pre tags don't accept aria-label without an
  // appropriate role, we add a SR only text instead
  var codeBlockLabelElement = (0, _react2.jsx)(_react.default.Fragment, null, _services.tabularCopyMarkers.hiddenNoCopyBoundary, (0, _react2.jsx)(_accessibility.EuiScreenReaderOnly, null, (0, _react2.jsx)("div", null, codeBlockLabel)), _services.tabularCopyMarkers.hiddenNoCopyBoundary);
  return (0, _react2.jsx)("div", {
    css: cssStyles,
    className: (0, _classnames.default)('euiCodeBlock', className),
    style: overflowHeightStyles
  }, isVirtualized ? (0, _react2.jsx)(_code_block_virtualized.EuiCodeBlockVirtualized, {
    data: data,
    rowHeight: fontSizeToRowHeightMap[fontSize],
    overflowHeight: overflowHeight,
    preProps: preProps,
    codeProps: codeProps
  }) : (0, _react2.jsx)("pre", (0, _extends2.default)({}, preProps, {
    ref: combinedRef,
    style: overflowHeightStyles
  }), codeBlockLabelElement, (0, _react2.jsx)("code", codeProps, content)), (0, _react2.jsx)(_code_block_controls.EuiCodeBlockControls, {
    controls: [fullScreenButton, copyButton],
    paddingSize: paddingSize
  }), isFullScreen && (0, _react2.jsx)(_code_block_full_screen.EuiCodeBlockFullScreenWrapper, {
    onClose: onKeyDown
  }, isVirtualized ? (0, _react2.jsx)(_code_block_virtualized.EuiCodeBlockVirtualized, {
    data: data,
    rowHeight: fontSizeToRowHeightMap.l,
    preProps: preFullscreenProps,
    codeProps: codeProps
  }) : (0, _react2.jsx)("pre", preFullscreenProps, codeBlockLabelElement, (0, _react2.jsx)("code", codeProps, content)), (0, _react2.jsx)(_code_block_controls.EuiCodeBlockControls, {
    controls: [fullScreenButton, copyButton],
    paddingSize: "l"
  })));
};