"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiCodeBlockAnnotation = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireWildcard(require("react"));
var _services = require("../../services");
var _button = require("../../themes/amsterdam/global_styling/mixins/button");
var _i18n = require("../i18n");
var _popover = require("../popover");
var _icon = require("../icon");
var _code_block_annotations = require("./code_block_annotations.style");
var _react2 = require("@emotion/react");
var _excluded = ["lineNumber", "children"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var EuiCodeBlockAnnotation = exports.EuiCodeBlockAnnotation = function EuiCodeBlockAnnotation(_ref) {
  var lineNumber = _ref.lineNumber,
    children = _ref.children,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var _useState = (0, _react.useState)(false),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    isOpen = _useState2[0],
    setIsOpen = _useState2[1];
  var ariaLabel = (0, _i18n.useEuiI18n)('euiCodeBlockAnnotations.ariaLabel', 'Click to view a code annotation for line {lineNumber}', {
    lineNumber: lineNumber
  });
  var styles = (0, _services.useEuiMemoizedStyles)(_code_block_annotations.euiCodeBlockAnnotationsStyles);
  var buttonIconFocusStyle = (0, _button.useEuiButtonFocusCSS)();
  var cssButtonIconStyles = [styles.euiCodeBlockAnnotation__buttonIcon, buttonIconFocusStyle];
  var _useEuiTheme = (0, _services.useEuiTheme)(),
    euiTheme = _useEuiTheme.euiTheme,
    colorMode = _useEuiTheme.colorMode;
  var isDarkMode = colorMode === 'DARK';
  var iconColor = isDarkMode ? euiTheme.colors.ink : 'ghost';
  return (0, _react2.jsx)(_popover.EuiPopover, (0, _extends2.default)({
    css: styles.euiCodeBlockAnnotation
  }, rest, {
    isOpen: isOpen,
    closePopover: function closePopover() {
      return setIsOpen(false);
    },
    button: (0, _react2.jsx)("button", {
      onClick: function onClick() {
        return setIsOpen(!isOpen);
      },
      "aria-label": ariaLabel,
      css: cssButtonIconStyles,
      "data-test-subj": "euiCodeBlockAnnotationIcon"
    }, (0, _react2.jsx)(_icon.EuiIcon, {
      type: AnnotationInfoIcon,
      size: "s",
      color: iconColor
    })),
    zIndex: Number(euiTheme.levels.mask) + 1 // Ensure fullscreen annotation popovers sit above the mask
    ,
    anchorPosition: "downLeft",
    panelProps: {
      'data-test-subj': 'euiCodeBlockAnnotationPopover'
    }
  }), children);
};
var AnnotationInfoIcon = function AnnotationInfoIcon(props) {
  return (0, _react2.jsx)("svg", (0, _extends2.default)({
    width: 11,
    height: 11,
    viewBox: "0 0 16 16",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, props), (0, _react2.jsx)("path", {
    fillRule: "evenodd",
    clipRule: "evenodd",
    d: "M7.139 14l-.052-6.007H5V6.28h4.111l.052 6.007h1.915V14h-3.94zM6.712 3.38c0-.396.118-.725.354-.987S7.639 2 8.077 2c.438 0 .777.131 1.016.393.24.262.359.591.359.987 0 .39-.12.714-.359.972s-.578.388-1.016.388c-.438 0-.775-.13-1.011-.388-.236-.258-.354-.582-.354-.972z"
  }));
};