"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiCollapsibleNav = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _flyout = require("../flyout");
var _collapsible_nav = require("./collapsible_nav.styles");
var _react2 = require("@emotion/react");
var _excluded = ["id", "children", "className", "isDocked", "isOpen", "button", "showButtonIfDocked", "dockedBreakpoint", "as", "size", "side", "ownFocus", "outsideClickCloses", "closeButtonPosition", "paddingSize", "focusTrapProps"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
// Extend all the flyout props except `onClose` because we handle this internally
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var EuiCollapsibleNav = exports.EuiCollapsibleNav = function EuiCollapsibleNav(_ref) {
  var id = _ref.id,
    children = _ref.children,
    className = _ref.className,
    _ref$isDocked = _ref.isDocked,
    isDocked = _ref$isDocked === void 0 ? false : _ref$isDocked,
    _ref$isOpen = _ref.isOpen,
    isOpen = _ref$isOpen === void 0 ? false : _ref$isOpen,
    button = _ref.button,
    _ref$showButtonIfDock = _ref.showButtonIfDocked,
    showButtonIfDocked = _ref$showButtonIfDock === void 0 ? false : _ref$showButtonIfDock,
    _ref$dockedBreakpoint = _ref.dockedBreakpoint,
    dockedBreakpoint = _ref$dockedBreakpoint === void 0 ? 'l' : _ref$dockedBreakpoint,
    _ref$as = _ref.as,
    as = _ref$as === void 0 ? 'nav' : _ref$as,
    _ref$size = _ref.size,
    size = _ref$size === void 0 ? 320 : _ref$size,
    _ref$side = _ref.side,
    side = _ref$side === void 0 ? 'left' : _ref$side,
    _ref$ownFocus = _ref.ownFocus,
    ownFocus = _ref$ownFocus === void 0 ? true : _ref$ownFocus,
    _ref$outsideClickClos = _ref.outsideClickCloses,
    outsideClickCloses = _ref$outsideClickClos === void 0 ? true : _ref$outsideClickClos,
    _ref$closeButtonPosit = _ref.closeButtonPosition,
    closeButtonPosition = _ref$closeButtonPosit === void 0 ? 'outside' : _ref$closeButtonPosit,
    _ref$paddingSize = _ref.paddingSize,
    paddingSize = _ref$paddingSize === void 0 ? 'none' : _ref$paddingSize,
    _ref$focusTrapProps = _ref.focusTrapProps,
    _focusTrapProps = _ref$focusTrapProps === void 0 ? {} : _ref$focusTrapProps,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var flyoutID = (0, _services.useGeneratedHtmlId)({
    conditionalId: id,
    suffix: 'euiCollapsibleNav'
  });
  var buttonRef = (0, _react.useRef)();
  var combinedButtonRef = (0, _services.useCombinedRefs)([button === null || button === void 0 ? void 0 : button.props.ref, buttonRef]);
  var focusTrapProps = _objectSpread(_objectSpread({}, _focusTrapProps), {}, {
    shards: [buttonRef].concat((0, _toConsumableArray2.default)(_focusTrapProps.shards || []))
  });
  var windowIsLargeEnoughToPush = (0, _services.useIsWithinMinBreakpoint)(dockedBreakpoint);
  var navIsDocked = isDocked && windowIsLargeEnoughToPush;
  var flyoutType = navIsDocked ? 'push' : 'overlay';
  var classes = (0, _classnames.default)('euiCollapsibleNav', className);
  var styles = (0, _services.useEuiMemoizedStyles)(_collapsible_nav.euiCollapsibleNavStyles);
  var cssStyles = [styles.euiCollapsibleNav, styles[flyoutType]];

  // Show a trigger button if one was passed but
  // not if navIsDocked and showButtonIfDocked is false
  var trigger = navIsDocked && !showButtonIfDocked ? undefined : button && /*#__PURE__*/(0, _react.cloneElement)(button, {
    'aria-controls': flyoutID,
    'aria-expanded': isOpen,
    'aria-pressed': isOpen,
    // When EuiOutsideClickDetector is enabled, we don't want both the toggle button and document touches/clicks to happen, they'll cancel eachother out
    onTouchEnd: function onTouchEnd(e) {
      e.nativeEvent.stopImmediatePropagation();
    },
    onMouseUpCapture: function onMouseUpCapture(e) {
      e.nativeEvent.stopImmediatePropagation();
    },
    ref: combinedButtonRef
  });
  var flyout = (0, _react2.jsx)(_flyout.EuiFlyout, (0, _extends2.default)({
    id: flyoutID,
    css: cssStyles,
    className: classes
    // Flyout props we set different defaults for
    ,
    as: as,
    size: size,
    side: side,
    ownFocus: ownFocus,
    outsideClickCloses: outsideClickCloses,
    closeButtonPosition: closeButtonPosition,
    paddingSize: paddingSize,
    focusTrapProps: focusTrapProps
  }, rest, {
    // Props dependent on internal docked status
    type: flyoutType,
    hideCloseButton: navIsDocked,
    pushMinBreakpoint: dockedBreakpoint
  }), children);
  return (0, _react2.jsx)(_react.default.Fragment, null, trigger, (isOpen || navIsDocked) && flyout);
};