"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KibanaCollapsibleNavSolution = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../../services");
var _i18n = require("../../i18n");
var _icon = require("../../icon");
var _popover = require("../../popover");
var _list_group = require("../../list_group");
var _context = require("../context");
var _collapsible_nav_link = require("../collapsible_nav_item/collapsible_nav_link");
var _collapsible_nav_item = require("../collapsible_nav_item/collapsible_nav_item");
var _collapsed_nav_popover = require("../collapsible_nav_item/collapsed/collapsed_nav_popover");
var _collapsible_nav_kibana_solution = require("./collapsible_nav_kibana_solution.styles");
var _react2 = require("@emotion/react");
var _excluded = ["title", "icon", "solutions", "items", "className"],
  _excluded2 = ["title", "icon", "isSecondary"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
/**
 * This component should only ever be used as a **top-level component**.
 * It also should **not** be used in the nav footer.
 *
 * This component is **very** specific to Kibana and is not meant to be a generic component.
 */
var KibanaCollapsibleNavSolution = exports.KibanaCollapsibleNavSolution = function KibanaCollapsibleNavSolution(_ref) {
  var title = _ref.title,
    icon = _ref.icon,
    _ref$solutions = _ref.solutions,
    solutions = _ref$solutions === void 0 ? [] : _ref$solutions,
    items = _ref.items,
    className = _ref.className,
    props = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var _useContext = (0, _react.useContext)(_context.EuiCollapsibleNavContext),
    isCollapsed = _useContext.isCollapsed,
    isPush = _useContext.isPush;
  var _useState = (0, _react.useState)(false),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    isSolutionSwitcherOpen = _useState2[0],
    setIsSolutionSwitcherOpen = _useState2[1];
  var classes = (0, _classnames.default)('kibanaCollapsibleNavSolution', className);
  var styles = (0, _services.useEuiMemoizedStyles)(_collapsible_nav_kibana_solution.euiCollapsibleNavKibanaSolutionStyles);
  var cssStyles = [styles.euiCollapsibleNavKibanaSolution, isPush && isCollapsed ? styles.collapsed : styles.uncollapsed];
  var solutionSwitcherIcon = 'layers';
  var solutionSolutionSwitcherTitle = (0, _i18n.useEuiI18n)('euiCollapsibleNavKibanaSolution.switcherTitle', 'Solution view');
  var solutionSolutionSwitcherAriaLabel = (0, _i18n.useEuiI18n)('euiCollapsibleNavKibanaSolution.switcherAriaLabel', ' - click to switch to another solution');
  var solutionSolutionGroupLabel = (0, _i18n.useEuiI18n)('euiCollapsibleNavKibanaSolution.groupLabel', 'Navigate to solution');
  var closeSolutionPopover = (0, _react.useCallback)(function (event) {
    var _childItem$firstEleme;
    // Allow child items to stop the popover from being closed
    if (event.isPropagationStopped()) return;
    // Only listen for clicks on child items - currentTarget is the parent <ul>
    if (event.target === event.currentTarget) return;

    // Only close the popover if the item is a clickable link or button
    var target = event.target;
    var childItem = target.closest('.euiListGroupItem');
    if (['A', 'BUTTON'].includes((childItem === null || childItem === void 0 || (_childItem$firstEleme = childItem.firstElementChild) === null || _childItem$firstEleme === void 0 ? void 0 : _childItem$firstEleme.tagName) || '')) {
      setIsSolutionSwitcherOpen(false);
    }
  }, []);
  var solutionSwitcherContent = (0, _react.useMemo)(function () {
    var _parseListItems = parseListItems(solutions),
      _parseListItems2 = (0, _slicedToArray2.default)(_parseListItems, 2),
      primaryItems = _parseListItems2[0],
      secondaryItems = _parseListItems2[1];
    return (0, _react2.jsx)(_react.default.Fragment, null, (0, _react2.jsx)(_list_group.EuiListGroup, {
      "data-test-subj": "kibanaSolutionSwitcherList",
      "aria-label": solutionSolutionGroupLabel,
      listItems: primaryItems,
      size: "s",
      bordered: true,
      onClick: closeSolutionPopover
    }), secondaryItems.length > 0 && (0, _react2.jsx)(_react.default.Fragment, null, (0, _react2.jsx)(_list_group.EuiListGroup, {
      listItems: secondaryItems,
      size: "s",
      css: styles.euiCollapsibleNavKibanaSolution__secondaryItems,
      onClick: closeSolutionPopover
    })));
  }, [solutions, solutionSolutionGroupLabel, closeSolutionPopover, styles]);
  var sharedPopoverProps = {
    'aria-label': solutionSolutionSwitcherTitle,
    panelProps: {
      css: styles.euiCollapsibleNavKibanaSolution__switcherPopover
    },
    panelPaddingSize: 's',
    display: 'block'
  };
  return (0, _react2.jsx)("div", (0, _extends2.default)({
    className: classes,
    css: cssStyles
  }, props), isCollapsed && isPush ? (0, _react2.jsx)(_react.default.Fragment, null, (0, _react2.jsx)(_collapsed_nav_popover.EuiCollapsedNavPopover, {
    icon: icon,
    title: title,
    items: items
  }), (0, _react2.jsx)(_collapsed_nav_popover.EuiCollapsedNavPopover, (0, _extends2.default)({}, sharedPopoverProps, {
    icon: solutionSwitcherIcon,
    title: solutionSolutionSwitcherTitle,
    items: [{
      renderItem: function renderItem() {
        return solutionSwitcherContent;
      }
    }],
    "data-test-subj": "kibanaSolutionSwitcherDocked"
  }))) : (0, _react2.jsx)(_react.default.Fragment, null, (0, _react2.jsx)(_popover.EuiInputPopover, (0, _extends2.default)({}, sharedPopoverProps, {
    fullWidth: true
    // Use the default EuiPopover focus trap, not the EuiInputPopover focus trap
    ,
    disableFocusTrap: true,
    ownFocus: true,
    isOpen: isSolutionSwitcherOpen,
    closePopover: function closePopover() {
      return setIsSolutionSwitcherOpen(false);
    },
    input: (0, _react2.jsx)(_collapsible_nav_link.EuiCollapsibleNavLink, {
      css: styles.euiCollapsibleNavKibanaSolution__title,
      onClick: function onClick() {
        return setIsSolutionSwitcherOpen(function (isOpen) {
          return !isOpen;
        });
      },
      isInteractive: true,
      isSelected: isSolutionSwitcherOpen,
      "data-test-subj": "kibanaSolutionSwitcher"
    }, (0, _react2.jsx)(_icon.EuiIcon, {
      type: icon,
      css: styles.euiCollapsibleNavKibanaSolution__logo
    }), title, (0, _react2.jsx)(_icon.EuiIcon, {
      type: solutionSwitcherIcon,
      css: styles.euiCollapsibleNavKibanaSolution__switcherIcon,
      "aria-label": solutionSolutionSwitcherAriaLabel
    }))
  }), (0, _react2.jsx)(_popover.EuiPopoverTitle, null, solutionSolutionSwitcherTitle), solutionSwitcherContent), (0, _react2.jsx)(_collapsible_nav_item.EuiCollapsibleNavSubItems, {
    items: items,
    role: "group",
    "aria-label": title
  })));
};

/**
 * Tweak EuiListGroup's items API to match EuiCollapsibleNav's
 * more closely (primarily label->title, iconType->icon),
 * and also to allow passing secondary items in the same array
 * (which will get rendered in a separate non-bordered group)
 */

var parseListItems = function parseListItems(items) {
  var primaryItems = [];
  var secondaryItems = [];
  items.forEach(function (_ref2) {
    var title = _ref2.title,
      icon = _ref2.icon,
      isSecondary = _ref2.isSecondary,
      item = (0, _objectWithoutProperties2.default)(_ref2, _excluded2);
    var arrayToPushTo = isSecondary ? secondaryItems : primaryItems;
    arrayToPushTo.push(_objectSpread(_objectSpread({}, item), {}, {
      label: title,
      iconType: icon
    }));
  });
  return [primaryItems, secondaryItems];
};