"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiCollapsibleNavFooter = exports.EuiCollapsibleNavBody = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _flyout = require("../flyout");
var _context = require("./context");
var _collapsible_nav_body_footer = require("./collapsible_nav_body_footer.styles");
var _react2 = require("@emotion/react");
var _excluded = ["className"],
  _excluded2 = ["className", "children"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
/**
 * These components are incredibly light wrappers around `EuiFlyoutBody`
 * and `EuiFlyoutFooter` with collapsible nav-specific styling/considerations.
 *
 * Note: They are not intended to be used standalone outside of EuiCollapsibleNav
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var EuiCollapsibleNavBody = exports.EuiCollapsibleNavBody = function EuiCollapsibleNavBody(_ref) {
  var className = _ref.className,
    props = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var classes = (0, _classnames.default)('euiCollapsibleNav__body', className);
  var _useContext = (0, _react.useContext)(_context.EuiCollapsibleNavContext),
    isCollapsed = _useContext.isCollapsed,
    isPush = _useContext.isPush;
  var cssStyles = [_collapsible_nav_body_footer.euiCollapsibleNavBodyStyles.euiCollapsibleNav__body, isCollapsed && isPush && _collapsible_nav_body_footer.euiCollapsibleNavBodyStyles.isPushCollapsed];
  return (0, _react2.jsx)(_flyout.EuiFlyoutBody, (0, _extends2.default)({
    className: classes,
    css: cssStyles
    // Since this is a nav, we can almost guarantee there will be clickable
    // children/links that will enable scrolling. As such, we're optimistically
    // removing the extra tab stop
    ,
    scrollableTabIndex: -1
  }, props));
};
var EuiCollapsibleNavFooter = exports.EuiCollapsibleNavFooter = function EuiCollapsibleNavFooter(_ref2) {
  var className = _ref2.className,
    children = _ref2.children,
    props = (0, _objectWithoutProperties2.default)(_ref2, _excluded2);
  var classes = (0, _classnames.default)('euiCollapsibleNav__footer', className);
  var _useContext2 = (0, _react.useContext)(_context.EuiCollapsibleNavContext),
    isCollapsed = _useContext2.isCollapsed,
    isPush = _useContext2.isPush;
  var styles = (0, _services.useEuiMemoizedStyles)(_collapsible_nav_body_footer.euiCollapsibleNavFooterStyles);
  var cssStyles = styles.euiCollapsibleNav__footer;
  var overflowWrapperStyles = [styles.euiFlyoutFooter__overflow, isCollapsed && isPush && styles.isPushCollapsed];
  return (0, _react2.jsx)(_flyout.EuiFlyoutFooter, (0, _extends2.default)({
    className: classes,
    css: cssStyles
  }, props), (0, _react2.jsx)("div", {
    css: overflowWrapperStyles
  }, children));
};