"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiCollapsedNavButton = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../../../services");
var _button_icon = require("../../../button/button_icon");
var _tool_tip = require("../../../tool_tip");
var _context = require("../../context");
var _collapsed_nav_button = require("./collapsed_nav_button.styles");
var _i18n = require("../../../i18n");
var _react2 = require("@emotion/react");
var _excluded = ["href", "title", "icon", "iconProps", "isSelected", "onClick", "hideToolTip", "linkProps", "titleElement"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var EuiCollapsedNavButton = exports.EuiCollapsedNavButton = function EuiCollapsedNavButton(_ref) {
  var href = _ref.href,
    title = _ref.title,
    icon = _ref.icon,
    iconProps = _ref.iconProps,
    isSelected = _ref.isSelected,
    onClick = _ref.onClick,
    hideToolTip = _ref.hideToolTip,
    linkProps = _ref.linkProps,
    titleElement = _ref.titleElement,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var _useContext = (0, _react.useContext)(_context.EuiCollapsibleNavContext),
    side = _useContext.side;
  var buttonStyles = (0, _services.useEuiMemoizedStyles)(_collapsed_nav_button.euiCollapsedNavButtonStyles);
  var buttonCssStyles = [buttonStyles.euiCollapsedNavButton, isSelected && buttonStyles.isSelected, linkProps === null || linkProps === void 0 ? void 0 : linkProps.css];
  var buttonClassName = (0, _classnames.default)('euiCollapsedNavButton', linkProps === null || linkProps === void 0 ? void 0 : linkProps.className);
  var tooltipStyles = (0, _services.useEuiMemoizedStyles)(_collapsed_nav_button.euiCollapsedNavItemTooltipStyles);
  var tooltipCssStyles = [tooltipStyles.euiCollapsedNavItemTooltip, tooltipStyles[side], hideToolTip && tooltipStyles.hidden];
  var buttonIconAriaLabel = (0, _i18n.useEuiI18n)('euiCollapsedNavButton.ariaLabelButtonIcon', '{title}, quick navigation menu', {
    title: title
  });
  return (0, _react2.jsx)(_tool_tip.EuiToolTip, {
    content: title,
    css: tooltipCssStyles,
    position: side,
    display: "block",
    anchorProps: rest,
    repositionOnScroll: true
  }, (0, _react2.jsx)(_button_icon.EuiButtonIcon, (0, _extends2.default)({
    "data-test-subj": "euiCollapsedNavButton",
    size: "s",
    color: "text",
    href: href,
    onClick: onClick,
    "aria-label": buttonIconAriaLabel
  }, linkProps, {
    // Exclusive union shenanigans
    className: buttonClassName,
    css: buttonCssStyles,
    iconType: icon || 'link',
    iconSize: iconProps === null || iconProps === void 0 ? void 0 : iconProps.size,
    isSelected: isSelected
  })));
};