"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiCollapsedNavItem = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireDefault(require("react"));
var _collapsed_nav_button = require("./collapsed_nav_button");
var _collapsed_nav_popover = require("./collapsed_nav_popover");
var _classnames = _interopRequireDefault(require("classnames"));
var _react2 = require("@emotion/react");
var _excluded = ["className", "href", "linkProps", "items", "accordionProps", "isCollapsible"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
/**
 * The collapsed nav item state only shows on larger/non-mobile screens
 * and collapses top-level link/accordion items to only rendering icons.
 *
 * Accordions turn into popovers, links turn into icon buttons
 */
var EuiCollapsedNavItem = exports.EuiCollapsedNavItem = function EuiCollapsedNavItem(_ref) {
  var className = _ref.className,
    href = _ref.href,
    linkProps = _ref.linkProps,
    items = _ref.items,
    accordionProps = _ref.accordionProps,
    isCollapsible = _ref.isCollapsible,
    props = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var classes = (0, _classnames.default)('euiCollapsedNavItem', className);
  return items ? (0, _react2.jsx)(_collapsed_nav_popover.EuiCollapsedNavPopover, (0, _extends2.default)({
    items: items,
    className: classes
  }, props)) : (0, _react2.jsx)(_collapsed_nav_button.EuiCollapsedNavButton, (0, _extends2.default)({
    href: href,
    linkProps: linkProps,
    className: classes
  }, props));
};