"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiCollapsedNavPopover = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireWildcard(require("react"));
var _services = require("../../../../services");
var _popover = require("../../../popover");
var _context = require("../../context");
var _collapsible_nav_item = require("../collapsible_nav_item");
var _collapsed_nav_button = require("./collapsed_nav_button");
var _collapsed_nav_popover = require("./collapsed_nav_popover.styles");
var _react2 = require("@emotion/react");
var _excluded = ["items", "title", "titleElement", "icon", "iconProps", "isSelected"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var EuiCollapsedNavPopover = exports.EuiCollapsedNavPopover = function EuiCollapsedNavPopover(_ref) {
  var _rest$panelProps;
  var items = _ref.items,
    title = _ref.title,
    _ref$titleElement = _ref.titleElement,
    TitleElement = _ref$titleElement === void 0 ? 'span' : _ref$titleElement,
    icon = _ref.icon,
    iconProps = _ref.iconProps,
    isSelected = _ref.isSelected,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var styles = (0, _services.useEuiMemoizedStyles)(_collapsed_nav_popover.euiCollapsedNavPopoverStyles);
  var _useState = (0, _react.useState)(false),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    isPopoverOpen = _useState2[0],
    setIsPopoverOpen = _useState2[1];
  var togglePopover = (0, _react.useCallback)(function () {
    return setIsPopoverOpen(function (isOpen) {
      return !isOpen;
    });
  }, []);
  var closePopover = (0, _react.useCallback)(function () {
    return setIsPopoverOpen(false);
  }, []);
  var closePopoverClick = (0, _react.useCallback)(function (event) {
    closePopover();
    // Visually hide the tooltip for mouse users only
    var isMouseEvent = event.screenX !== 0 && event.screenY !== 0;
    if (isMouseEvent) setIsTooltipHidden(true);
  }, [closePopover]);
  var _useState3 = (0, _react.useState)(false),
    _useState4 = (0, _slicedToArray2.default)(_useState3, 2),
    isTooltipHidden = _useState4[0],
    setIsTooltipHidden = _useState4[1];
  var reshowTooltip = (0, _react.useCallback)(function () {
    return setIsTooltipHidden(false);
  }, []);
  var navContext = (0, _react.useContext)(_context.EuiCollapsibleNavContext);
  return (0, _react2.jsx)(_popover.EuiPopover, (0, _extends2.default)({
    closePopover: closePopover,
    isOpen: isPopoverOpen,
    display: "block",
    anchorPosition: "rightUp",
    panelPaddingSize: "none",
    repositionOnScroll: true,
    button: (0, _react2.jsx)(_collapsed_nav_button.EuiCollapsedNavButton, {
      title: title,
      icon: icon || 'boxesHorizontal',
      iconProps: iconProps,
      isSelected: isSelected,
      onClick: togglePopover,
      hideToolTip: isPopoverOpen || isTooltipHidden,
      linkProps: {
        onMouseOver: reshowTooltip
      }
    })
  }, rest, {
    panelProps: _objectSpread(_objectSpread({}, rest.panelProps), {}, {
      css: [styles.euiCollapsedNavPopover__panel, (_rest$panelProps = rest.panelProps) === null || _rest$panelProps === void 0 ? void 0 : _rest$panelProps.css]
    })
  }), (0, _react2.jsx)(_popover.EuiPopoverTitle, null, (0, _react2.jsx)(TitleElement, {
    css: styles.euiCollapsedNavPopover__title,
    className: "eui-textTruncate"
  }, title)), (0, _react2.jsx)("div", {
    css: styles.euiCollapsedNavPopover__items
  }, (0, _react2.jsx)(_context.EuiCollapsibleNavContext.Provider, {
    value: _objectSpread(_objectSpread({}, navContext), {}, {
      closePortals: closePopoverClick
    })
  }, items.map(function (item, index) {
    return (0, _react2.jsx)(_collapsible_nav_item.EuiCollapsibleNavSubItem, (0, _extends2.default)({
      key: index
    }, item));
  }))));
};