"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiCollapsibleNavAccordion = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../../services");
var _accordion = require("../../accordion");
var _collapsible_nav_item = require("./collapsible_nav_item");
var _collapsible_nav_link = require("./collapsible_nav_link");
var _collapsible_nav_accordion = require("./collapsible_nav_accordion.styles");
var _react2 = require("@emotion/react");
var _excluded = ["id", "className", "items", "isSubItem", "isSelected", "accordionProps", "buttonContent", "children"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
/**
 * Internal nav accordion component.
 *
 * Renders children as either a nav link or any number/nesting of more nav accordions.
 * Triggering the open/closed state is handled only by the accordion `arrow` for
 * UX consistency, as accordion/nav titles can be their own links to pages.
 */
var EuiCollapsibleNavAccordion = exports.EuiCollapsibleNavAccordion = function EuiCollapsibleNavAccordion(_ref) {
  var _accordionProps$arrow;
  var id = _ref.id,
    className = _ref.className,
    items = _ref.items,
    isSubItem = _ref.isSubItem,
    isSelected = _ref.isSelected,
    accordionProps = _ref.accordionProps,
    buttonContent = _ref.buttonContent,
    _children = _ref.children,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var classes = (0, _classnames.default)('euiCollapsibleNavAccordion', className);
  var groupID = (0, _services.useGeneratedHtmlId)({
    conditionalId: id
  });
  var styles = (0, _services.useEuiMemoizedStyles)(_collapsible_nav_accordion.euiCollapsibleNavAccordionStyles);
  var cssStyles = [styles.euiCollapsibleNavAccordion, isSubItem ? styles.isSubItem : styles.isTopItem, isSelected && styles.isSelected, accordionProps === null || accordionProps === void 0 ? void 0 : accordionProps.css];
  return (0, _react2.jsx)(_accordion.EuiAccordion, (0, _extends2.default)({
    id: groupID,
    className: classes,
    initialIsOpen: isSelected,
    buttonContent: (0, _react2.jsx)(_collapsible_nav_link.EuiCollapsibleNavLink, {
      isSelected: isSelected,
      isSubItem: isSubItem,
      isInteractive: false
    }, buttonContent),
    arrowDisplay: "right"
  }, rest, accordionProps, {
    css: cssStyles,
    arrowProps: _objectSpread(_objectSpread({
      iconSize: 's'
    }, accordionProps === null || accordionProps === void 0 ? void 0 : accordionProps.arrowProps), {}, {
      css: [styles.euiCollapsibleNavAccordion__arrow, accordionProps === null || accordionProps === void 0 || (_accordionProps$arrow = accordionProps.arrowProps) === null || _accordionProps$arrow === void 0 ? void 0 : _accordionProps$arrow.css]
    })
  }), (0, _react2.jsx)(_collapsible_nav_item.EuiCollapsibleNavSubItems, {
    items: items,
    isSubItem: isSubItem,
    className: "euiCollapsibleNavAccordion__children"
  }));
};