"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiColorPickerSwatchStyles = void 0;
var _react = require("@emotion/react");
var _services = require("../../services");
var _global_styling = require("../../global_styling");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var euiColorPickerSwatchStyles = exports.euiColorPickerSwatchStyles = function euiColorPickerSwatchStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    euiColorPickerSwatch: /*#__PURE__*/(0, _react.css)("display:inline-block;", (0, _global_styling.logicalSizeCSS)(euiTheme.size.l), " border-radius:", (0, _global_styling.mathWithUnits)(euiTheme.border.radius.medium, function (x) {
      return x / 2;
    }), ";border:", euiTheme.border.width.thin, " solid ", (0, _services.transparentize)(euiTheme.colors.fullShade, 0.1), ";box-shadow:inset 0 0 0 ", euiTheme.border.width.thin, " ", (0, _services.transparentize)(euiTheme.colors.emptyShade, 0.05), ";cursor:pointer;&:disabled{cursor:default;}&:focus{", (0, _global_styling.euiOutline)(euiThemeContext, 'center'), ";};label:euiColorPickerSwatch;")
  };
};