"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiComment = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _timeline = require("../timeline");
var _comment_event = require("./comment_event");
var _comment_timeline = require("./comment_timeline");
var _react2 = require("@emotion/react");
var _excluded = ["children", "className", "username", "event", "actions", "timestamp", "timelineAvatar", "timelineAvatarAriaLabel", "eventColor", "eventIcon", "eventIconAriaLabel"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var EuiComment = exports.EuiComment = function EuiComment(_ref) {
  var children = _ref.children,
    className = _ref.className,
    username = _ref.username,
    event = _ref.event,
    actions = _ref.actions,
    timestamp = _ref.timestamp,
    timelineAvatar = _ref.timelineAvatar,
    timelineAvatarAriaLabel = _ref.timelineAvatarAriaLabel,
    eventColor = _ref.eventColor,
    eventIcon = _ref.eventIcon,
    eventIconAriaLabel = _ref.eventIconAriaLabel,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var classes = (0, _classnames.default)('euiComment', className);
  var isTypeUpdate = !children;
  var verticalAlign = isTypeUpdate ? 'center' : 'top';
  var mainIcon = (0, _react2.jsx)(_comment_timeline.EuiCommentTimeline, {
    timelineAvatar: timelineAvatar,
    timelineAvatarAriaLabel: timelineAvatarAriaLabel
  });
  return (0, _react2.jsx)(_timeline.EuiTimelineItem, (0, _extends2.default)({
    verticalAlign: verticalAlign,
    className: classes,
    icon: mainIcon
  }, rest), (0, _react2.jsx)(_comment_event.EuiCommentEvent, {
    username: username,
    actions: actions,
    event: event,
    timestamp: timestamp,
    eventColor: eventColor,
    eventIcon: eventIcon,
    eventIconAriaLabel: eventIconAriaLabel
  }, children));
};