"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiCommentEvent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _global_styling = require("../../global_styling");
var _panel = require("../panel");
var _avatar = require("../avatar");
var _comment_event = require("./comment_event.styles");
var _react2 = require("@emotion/react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var EuiCommentEvent = exports.EuiCommentEvent = function EuiCommentEvent(_ref) {
  var children = _ref.children,
    className = _ref.className,
    eventIcon = _ref.eventIcon,
    eventIconAriaLabel = _ref.eventIconAriaLabel,
    username = _ref.username,
    timestamp = _ref.timestamp,
    event = _ref.event,
    actions = _ref.actions,
    eventColor = _ref.eventColor;
  var classes = (0, _classnames.default)('euiCommentEvent', className);

  /**
   * Branching logic
   */
  // the username is required so we only check if other elements are define
  var hasEventElements = eventIcon || timestamp || event || actions;
  var isTypeRegular = children && hasEventElements;
  var isTypeUpdate = !children && hasEventElements;
  var type;
  if (isTypeRegular) {
    type = 'regular';
  } else if (isTypeUpdate) {
    type = 'update';
  } else {
    type = 'custom';
  }
  if (isTypeRegular && !eventColor) {
    eventColor = 'subdued';
  }
  if (isTypeUpdate && !eventColor) {
    eventColor = 'transparent';
  }
  var showEventBorders = isTypeRegular;
  var panelProps = (0, _react.useMemo)(function () {
    return {
      color: type === 'custom' ? 'transparent' : eventColor,
      paddingSize: type === 'custom' ? 'none' : 's',
      borderRadius: type === 'regular' ? 'none' : 'm',
      hasShadow: false // `plain` color needs this
    };
  }, [type, eventColor]);
  var isFigure = isTypeRegular;
  var Element = isFigure ? 'figure' : 'div';
  var HeaderElement = isFigure ? 'figcaption' : 'div';

  /**
   * Styles
   */
  var borderStyles = (0, _global_styling.useEuiBorderColorCSS)();
  var styles = (0, _services.useEuiMemoizedStyles)(_comment_event.euiCommentEventStyles);
  var cssStyles = [styles.euiCommentEvent, showEventBorders && styles.border, showEventBorders && borderStyles[eventColor]];
  var headerStyles = (0, _services.useEuiMemoizedStyles)(_comment_event.euiCommentEventHeaderStyles);
  var cssHeaderStyles = [headerStyles.euiCommentEvent__header, showEventBorders && headerStyles.border, showEventBorders && borderStyles[eventColor]];
  var bodyStyles = (0, _services.useEuiMemoizedStyles)(_comment_event.euiCommentEventBodyStyles);
  var cssBodyStyles = [bodyStyles.euiCommentEvent__body, bodyStyles[type]];
  return (0, _react2.jsx)(Element, {
    className: classes,
    css: cssStyles,
    "data-type": type
  }, hasEventElements && (0, _react2.jsx)(HeaderElement, {
    className: "euiCommentEvent__header",
    css: cssHeaderStyles
  }, (0, _react2.jsx)(_panel.EuiPanel, panelProps, (0, _react2.jsx)("div", {
    className: "euiCommentEvent__headerMain",
    css: headerStyles.euiCommentEvent__headerMain
  }, (0, _react2.jsx)("div", {
    className: "euiCommentEvent__headerData",
    css: headerStyles.euiCommentEvent__headerData
  }, eventIcon && (0, _react2.jsx)(_avatar.EuiAvatar, {
    className: "euiCommentEvent__headerEventIcon",
    css: headerStyles.euiCommentEvent__headerEventIcon,
    size: "s",
    iconType: eventIcon,
    name: eventIconAriaLabel ? eventIconAriaLabel : '',
    color: "subdued",
    "aria-hidden": !eventIconAriaLabel
  }), username && (0, _react2.jsx)("div", {
    className: "euiCommentEvent__headerUsername",
    css: headerStyles.euiCommentEvent__headerUsername
  }, username), event && (0, _react2.jsx)("div", {
    className: "euiCommentEvent__headerEvent",
    css: headerStyles.euiCommentEvent__headerEvent
  }, event), timestamp && (0, _react2.jsx)("div", {
    className: "euiCommentEvent__headerTimestamp"
  }, (0, _react2.jsx)("time", null, timestamp))), actions && (0, _react2.jsx)("div", {
    className: "euiCommentEvent__headerActions",
    css: headerStyles.euiCommentEvent__headerActions
  }, actions)))), children && (0, _react2.jsx)("div", {
    className: "euiCommentEvent__body",
    css: cssBodyStyles
  }, children));
};