"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiCommentTimeline = void 0;
var _react = _interopRequireDefault(require("react"));
var _avatar = require("../avatar");
var _react2 = require("@emotion/react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var EuiCommentTimeline = exports.EuiCommentTimeline = function EuiCommentTimeline(_ref) {
  var timelineAvatar = _ref.timelineAvatar,
    timelineAvatarAriaLabel = _ref.timelineAvatarAriaLabel;
  var iconRender;
  var avatarClassName = 'euiCommentAvatar';
  var iconIsString = typeof timelineAvatar === 'string';
  if (iconIsString) {
    iconRender = (0, _react2.jsx)(_avatar.EuiAvatar, {
      className: avatarClassName,
      name: timelineAvatarAriaLabel || '',
      iconType: timelineAvatar,
      color: "subdued"
    });
  } else if (timelineAvatar) {
    iconRender = timelineAvatar;
  } else {
    iconRender = (0, _react2.jsx)(_avatar.EuiAvatar, {
      className: avatarClassName,
      name: timelineAvatarAriaLabel || '',
      iconType: "userAvatar",
      color: "subdued"
    });
  }
  return (0, _react2.jsx)(_react.default.Fragment, null, iconRender);
};