"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SIZES = exports.LAYOUT_ALIGN = exports.EuiContextMenuItem = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _href_validator = require("../../services/security/href_validator");
var _common = require("../common");
var _icon = require("../icon");
var _tool_tip = require("../tool_tip");
var _context_menu_item = require("./context_menu_item.styles");
var _react2 = require("@emotion/react");
var _excluded = ["children", "className", "hasPanel", "icon", "buttonRef", "disabled", "layoutAlign", "toolTipContent", "toolTipProps", "href", "target", "rel", "size"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var SIZES = exports.SIZES = ['s', 'm'];
var layoutAlignToClassNames = {
  center: null,
  top: 'euiContextMenu__itemLayout--top',
  bottom: 'euiContextMenu__itemLayout--bottom'
};
var LAYOUT_ALIGN = exports.LAYOUT_ALIGN = (0, _common.keysOf)(layoutAlignToClassNames);
var EuiContextMenuItem = exports.EuiContextMenuItem = function EuiContextMenuItem(_ref) {
  var children = _ref.children,
    className = _ref.className,
    hasPanel = _ref.hasPanel,
    icon = _ref.icon,
    buttonRef = _ref.buttonRef,
    _disabled = _ref.disabled,
    _ref$layoutAlign = _ref.layoutAlign,
    layoutAlign = _ref$layoutAlign === void 0 ? 'center' : _ref$layoutAlign,
    toolTipContent = _ref.toolTipContent,
    toolTipProps = _ref.toolTipProps,
    href = _ref.href,
    target = _ref.target,
    rel = _ref.rel,
    _ref$size = _ref.size,
    size = _ref$size === void 0 ? 'm' : _ref$size,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var isHrefValid = !href || (0, _href_validator.validateHref)(href);
  var disabled = _disabled || !isHrefValid;
  var classes = (0, _classnames.default)('euiContextMenuItem', className);
  var styles = (0, _services.useEuiMemoizedStyles)(_context_menu_item.euiContextMenuItemStyles);
  var cssStyles = [styles.euiContextMenuItem, styles.sizes[size], styles.layoutAlign[layoutAlign], disabled && styles.disabled];
  var iconInstance = icon && (typeof icon === 'string' ? (0, _react2.jsx)(_icon.EuiIcon, {
    type: icon,
    size: "m",
    className: "euiContextMenu__icon",
    css: styles.euiContextMenu__icon,
    color: "inherit" // forces the icon to inherit its parent color
  }) :
  // Assume it's already an instance of an icon.
  (0, _services.cloneElementWithCss)(icon, {
    css: styles.euiContextMenu__icon
  }));
  var arrow = hasPanel && (0, _react2.jsx)(_icon.EuiIcon, {
    type: "arrowRight",
    size: "m",
    className: "euiContextMenu__arrow",
    css: styles.euiContextMenuItem__arrow
  });
  var textStyles = [styles.text.euiContextMenuItem__text, size === 's' && styles.text.s];
  var buttonContent = (0, _react2.jsx)(_react.default.Fragment, null, iconInstance, (0, _react2.jsx)("span", {
    className: "euiContextMenuItem__text",
    css: textStyles
  }, children), arrow);
  var button;
  // <a> elements don't respect the `disabled` attribute. So if we're disabled, we'll just pretend
  // this is a button and piggyback off its disabled styles.
  if (href && !disabled) {
    var secureRel = (0, _services.getSecureRelForTarget)({
      href: href,
      target: target,
      rel: rel
    });
    button = (0, _react2.jsx)("a", (0, _extends2.default)({
      css: cssStyles,
      className: classes,
      href: href,
      target: target,
      rel: secureRel,
      ref: buttonRef
    }, rest), buttonContent);
  } else if (href || rest.onClick || toolTipContent) {
    button = (0, _react2.jsx)("button", (0, _extends2.default)({
      disabled: disabled,
      css: cssStyles,
      className: classes,
      type: "button",
      ref: buttonRef
    }, rest), buttonContent);
  } else {
    button = (0, _react2.jsx)("div", (0, _extends2.default)({
      css: cssStyles,
      className: classes,
      ref: buttonRef
    }, rest), buttonContent);
  }
  if (toolTipContent) {
    var anchorClasses = (0, _classnames.default)('eui-displayBlock', toolTipProps === null || toolTipProps === void 0 ? void 0 : toolTipProps.anchorClassName);
    return (0, _react2.jsx)(_tool_tip.EuiToolTip, (0, _extends2.default)({
      position: "right"
    }, toolTipProps, {
      anchorClassName: anchorClasses,
      content: toolTipContent
    }), button);
  } else {
    return button;
  }
};