"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiDataGridCell = void 0;
var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));
var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));
var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));
var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));
var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _classnames = _interopRequireDefault(require("classnames"));
var _react = _interopRequireWildcard(require("react"));
var _reactDom = require("react-dom");
var _utils = require("../../../../utils");
var _services = require("../../../../services");
var _accessibility = require("../../../accessibility");
var _i18n = require("../../../i18n");
var _text_truncate = require("../../../text_truncate");
var _resize_observer = require("../../../observer/resize_observer/resize_observer");
var _focus = require("../../utils/focus");
var _data_grid_cell_actions = require("./data_grid_cell_actions");
var _data_grid_cell_popover = require("./data_grid_cell_popover");
var _focus_utils = require("./focus_utils");
var _data_grid_cell = require("./data_grid_cell.styles");
var _react2 = require("@emotion/react");
var _excluded = ["renderCellValue", "cellContext", "column", "setCellContentsRef", "rowIndex", "colIndex", "rowHeightsOptions", "rowHeightUtils", "isControlColumn"],
  _excluded2 = ["width", "popoverContext", "interactiveCellId", "columnType", "className", "column", "style", "rowHeightUtils", "rowHeightsOptions", "rowManager", "pagination"],
  _excluded3 = ["isExpandable", "style", "className", "data-test-subj"],
  _excluded4 = ["columnId", "columnIndex", "rowIndex", "visibleRowIndex"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
var EuiDataGridCellContent = /*#__PURE__*/(0, _react.memo)(function (_ref) {
  var renderCellValue = _ref.renderCellValue,
    cellContext = _ref.cellContext,
    column = _ref.column,
    setCellContentsRef = _ref.setCellContentsRef,
    rowIndex = _ref.rowIndex,
    colIndex = _ref.colIndex,
    rowHeightsOptions = _ref.rowHeightsOptions,
    rowHeightUtils = _ref.rowHeightUtils,
    isControlColumn = _ref.isControlColumn,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  // React is more permissive than the TS types indicate
  var CellElement = renderCellValue;

  // Cell height type
  var rowHeight = rowHeightUtils === null || rowHeightUtils === void 0 ? void 0 : rowHeightUtils.getRowHeightOption(rowIndex, rowHeightsOptions);
  var cellHeightType = (0, _react.useMemo)(function () {
    return rowHeightUtils !== null && rowHeightUtils !== void 0 && rowHeightUtils.isAutoBelowLineCount(rowHeightsOptions, rowHeight) ? 'autoBelowLineCount' : (rowHeightUtils === null || rowHeightUtils === void 0 ? void 0 : rowHeightUtils.getHeightType(rowHeight)) || 'default';
  }, [rowHeightUtils, rowHeight, rowHeightsOptions]);

  // Classes and styles
  var classes = (0, _react.useMemo)(function () {
    return (0, _classnames.default)('euiDataGridRowCell__content', "euiDataGridRowCell__content--".concat(cellHeightType, "Height"), !isControlColumn && {
      'eui-textBreakWord': cellHeightType !== 'default',
      'eui-textTruncate': cellHeightType === 'default'
    });
  }, [cellHeightType, isControlColumn]);
  var styles = (0, _services.useEuiMemoizedStyles)(_data_grid_cell.euiDataGridRowCellStyles);
  var cssStyles = [styles.content.euiDataGridRowCell__content].concat((0, _toConsumableArray2.default)(isControlColumn ? [styles.content.controlColumn, styles.content.autoHeight] : [
  // Regular data cells should always inherit height from the row wrapper,
  // except for auto height
  cellHeightType === 'auto' || cellHeightType === 'autoBelowLineCount' ? styles.content.autoHeight : styles.content.defaultHeight]));
  return (0, _react2.jsx)(RenderTruncatedCellContent, {
    hasLineCountTruncation: (cellHeightType === 'lineCount' || cellHeightType === 'autoBelowLineCount') && !isControlColumn,
    rowHeight: rowHeight
  }, (0, _react2.jsx)("div", {
    ref: setCellContentsRef,
    "data-datagrid-cellcontent": true,
    className: classes,
    css: cssStyles
  }, (0, _react2.jsx)(CellElement, (0, _extends2.default)({
    isDetails: false,
    "data-test-subj": "cell-content",
    rowIndex: rowIndex,
    colIndex: colIndex,
    schema: (column === null || column === void 0 ? void 0 : column.schema) || rest.columnType
  }, cellContext, rest))));
});
EuiDataGridCellContent.displayName = 'EuiDataGridCellContent';
var EuiDataGridCell = exports.EuiDataGridCell = /*#__PURE__*/function (_Component) {
  function EuiDataGridCell() {
    var _this;
    (0, _classCallCheck2.default)(this, EuiDataGridCell);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _callSuper(this, EuiDataGridCell, [].concat(args));
    (0, _defineProperty2.default)(_this, "cellRef", /*#__PURE__*/(0, _react.createRef)());
    (0, _defineProperty2.default)(_this, "contentObserver", void 0);
    // Cell Content ResizeObserver
    (0, _defineProperty2.default)(_this, "popoverAnchorRef", /*#__PURE__*/(0, _react.createRef)());
    (0, _defineProperty2.default)(_this, "cellContentsRef", null);
    (0, _defineProperty2.default)(_this, "state", {
      cellProps: {},
      isFocused: false,
      isHovered: false
    });
    (0, _defineProperty2.default)(_this, "unsubscribeCell", void 0);
    (0, _defineProperty2.default)(_this, "style", null);
    (0, _defineProperty2.default)(_this, "updateCellFocusContext", function () {
      _this.context.setFocusedCell([_this.props.colIndex, _this.props.visibleRowIndex]);
    });
    (0, _defineProperty2.default)(_this, "takeFocus", function (preventScroll) {
      var cell = _this.cellRef.current;
      // Only focus the cell if not already focused on something in the cell
      if (cell && !cell.contains(document.activeElement)) {
        cell.focus({
          preventScroll: preventScroll
        });
      }
    });
    (0, _defineProperty2.default)(_this, "recalculateAutoHeight", function () {
      var _this$props = _this.props,
        rowHeightUtils = _this$props.rowHeightUtils,
        rowHeightsOptions = _this$props.rowHeightsOptions,
        rowIndex = _this$props.rowIndex;
      if (_this.cellContentsRef && rowHeightUtils && rowHeightUtils.isAutoHeight(rowIndex, rowHeightsOptions)) {
        var _this$props2 = _this.props,
          columnId = _this$props2.columnId,
          visibleRowIndex = _this$props2.visibleRowIndex;
        var rowHeight = _this.cellContentsRef.offsetHeight;
        rowHeightUtils.setRowHeight(rowIndex, columnId, rowHeight, visibleRowIndex);
      }
    });
    (0, _defineProperty2.default)(_this, "recalculateLineHeight", function () {
      if (!_this.props.setRowHeight) return; // setRowHeight is only passed by data_grid_body into one cell per row
      if (!_this.cellContentsRef) return;
      var _this$props3 = _this.props,
        rowHeightUtils = _this$props3.rowHeightUtils,
        rowHeightsOptions = _this$props3.rowHeightsOptions,
        rowIndex = _this$props3.rowIndex;
      var rowHeightOption = rowHeightUtils === null || rowHeightUtils === void 0 ? void 0 : rowHeightUtils.getRowHeightOption(rowIndex, rowHeightsOptions);
      if (rowHeightUtils !== null && rowHeightUtils !== void 0 && rowHeightUtils.isAutoBelowLineCount(rowHeightsOptions, rowHeightOption)) {
        return; // Using auto height instead
      }
      var isSingleLine = rowHeightOption == null; // Undefined rowHeightsOptions default to a single line
      var lineCount = isSingleLine ? 1 : rowHeightUtils === null || rowHeightUtils === void 0 ? void 0 : rowHeightUtils.getLineCount(rowHeightOption);
      if (lineCount) {
        var shouldUseHeightsCache = rowHeightUtils === null || rowHeightUtils === void 0 ? void 0 : rowHeightUtils.isRowHeightOverride(rowIndex, rowHeightsOptions);
        var height = rowHeightUtils.calculateHeightForLineCount(_this.cellContentsRef, lineCount);
        if (shouldUseHeightsCache) {
          var _this$props4 = _this.props,
            columnId = _this$props4.columnId,
            visibleRowIndex = _this$props4.visibleRowIndex;
          rowHeightUtils === null || rowHeightUtils === void 0 || rowHeightUtils.setRowHeight(rowIndex, columnId, height, visibleRowIndex);
        } else {
          _this.props.setRowHeight(height);
        }
      }
    });
    (0, _defineProperty2.default)(_this, "isFocusedCell", function () {
      var _this$context$focused, _this$context$focused2;
      return ((_this$context$focused = _this.context.focusedCell) === null || _this$context$focused === void 0 ? void 0 : _this$context$focused[0]) === _this.props.colIndex && ((_this$context$focused2 = _this.context.focusedCell) === null || _this$context$focused2 === void 0 ? void 0 : _this$context$focused2[1]) === _this.props.visibleRowIndex;
    });
    (0, _defineProperty2.default)(_this, "onFocusUpdate", function (isFocused) {
      var preventScroll = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
      _this.setState({
        isFocused: isFocused
      }, function () {
        if (isFocused) {
          _this.takeFocus(preventScroll);
        }
      });
    });
    (0, _defineProperty2.default)(_this, "setCellProps", function (cellProps) {
      _this.setState({
        cellProps: cellProps
      });
    });
    (0, _defineProperty2.default)(_this, "setCellContentsRef", function (ref) {
      _this.cellContentsRef = ref;
      if (ref && _resize_observer.hasResizeObserver) {
        _this.contentObserver = new window.ResizeObserver(function () {
          _this.recalculateAutoHeight();
          _this.recalculateLineHeight();
        });
        _this.contentObserver.observe(ref);
      } else if (_this.contentObserver) {
        _this.contentObserver.disconnect();
      }
    });
    (0, _defineProperty2.default)(_this, "isExpandable", function () {
      var _this$props$column, _this$state$cellProps;
      // A cell must always show an expansion popover if it has cell actions,
      // otherwise keyboard and screen reader users have no way of accessing them
      if ((_this$props$column = _this.props.column) !== null && _this$props$column !== void 0 && (_this$props$column = _this$props$column.cellActions) !== null && _this$props$column !== void 0 && _this$props$column.length) return true;

      // props.isExpandable inherits from column.isExpandable
      // state.cellProps allows consuming applications to override isExpandable on a per-cell basis
      return (_this$state$cellProps = _this.state.cellProps.isExpandable) !== null && _this$state$cellProps !== void 0 ? _this$state$cellProps : _this.props.isExpandable;
    });
    (0, _defineProperty2.default)(_this, "isPopoverOpen", function () {
      var _this$props$popoverCo = _this.props.popoverContext,
        popoverIsOpen = _this$props$popoverCo.popoverIsOpen,
        cellLocation = _this$props$popoverCo.cellLocation;
      return _this.isExpandable() && popoverIsOpen && cellLocation.colIndex === _this.props.colIndex && cellLocation.rowIndex === _this.props.visibleRowIndex;
    });
    (0, _defineProperty2.default)(_this, "handleCellPopover", function () {
      if (_this.isPopoverOpen()) {
        var _this$props$popoverCo2 = _this.props.popoverContext,
          setPopoverAnchor = _this$props$popoverCo2.setPopoverAnchor,
          setPopoverAnchorPosition = _this$props$popoverCo2.setPopoverAnchorPosition,
          setPopoverContent = _this$props$popoverCo2.setPopoverContent,
          setCellPopoverProps = _this$props$popoverCo2.setCellPopoverProps;

        // Set popover anchor
        var cellAnchorEl = _this.popoverAnchorRef.current;
        setPopoverAnchor(cellAnchorEl);
        // TODO: Potentially switch to `topLeft` based on occlusion with sticky header
        // @see https://github.com/elastic/eui/issues/7828
        setPopoverAnchorPosition('downLeft');

        // Set popover contents with cell content
        var _this$props5 = _this.props,
          renderCellPopover = _this$props5.renderCellPopover,
          renderCellValue = _this$props5.renderCellValue,
          cellContext = _this$props5.cellContext,
          rowIndex = _this$props5.rowIndex,
          colIndex = _this$props5.colIndex,
          column = _this$props5.column,
          columnId = _this$props5.columnId,
          columnType = _this$props5.columnType;
        var PopoverElement = renderCellPopover || _data_grid_cell_popover.DefaultCellPopover;
        var CellElement = renderCellValue;
        var sharedProps = {
          rowIndex: rowIndex,
          colIndex: colIndex,
          columnId: columnId,
          schema: (column === null || column === void 0 ? void 0 : column.schema) || columnType
        };
        var popoverContent = (0, _react2.jsx)(PopoverElement, (0, _extends2.default)({}, sharedProps, {
          cellContentsElement: _this.cellContentsRef,
          cellActions: (0, _react2.jsx)(_data_grid_cell_actions.EuiDataGridCellPopoverActions, (0, _extends2.default)({}, sharedProps, {
            column: column
          })),
          DefaultCellPopover: _data_grid_cell_popover.DefaultCellPopover,
          setCellPopoverProps: setCellPopoverProps
        }), (0, _react2.jsx)(CellElement, (0, _extends2.default)({}, cellContext, sharedProps, {
          setCellProps: _this.setCellProps,
          isExpandable: true,
          isExpanded: true,
          isDetails: true
        })));
        setPopoverContent(popoverContent);
      }
    });
    (0, _defineProperty2.default)(_this, "handleCellKeyDown", function (event) {
      if (_this.isExpandable()) {
        if (_this.isPopoverOpen()) return;
        var _this$props6 = _this.props,
          openCellPopover = _this$props6.popoverContext.openCellPopover,
          visibleRowIndex = _this$props6.visibleRowIndex,
          colIndex = _this$props6.colIndex;
        switch (event.key) {
          case _services.keys.ENTER:
          case _services.keys.F2:
            event.preventDefault();
            openCellPopover({
              rowIndex: visibleRowIndex,
              colIndex: colIndex
            });
            break;
        }
      }
    });
    (0, _defineProperty2.default)(_this, "handleCellExpansionClick", function () {
      var _this$props7 = _this.props,
        _this$props7$popoverC = _this$props7.popoverContext,
        openCellPopover = _this$props7$popoverC.openCellPopover,
        closeCellPopover = _this$props7$popoverC.closeCellPopover,
        visibleRowIndex = _this$props7.visibleRowIndex,
        colIndex = _this$props7.colIndex;
      if (_this.isPopoverOpen()) {
        closeCellPopover();
      } else {
        openCellPopover({
          rowIndex: visibleRowIndex,
          colIndex: colIndex
        });
      }
    });
    (0, _defineProperty2.default)(_this, "onMouseEnter", function () {
      return _this.setState({
        isHovered: true
      });
    });
    (0, _defineProperty2.default)(_this, "onMouseLeave", function () {
      return _this.setState({
        isHovered: false
      });
    });
    return _this;
  }
  (0, _inherits2.default)(EuiDataGridCell, _Component);
  return (0, _createClass2.default)(EuiDataGridCell, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      var _this$props8 = this.props,
        colIndex = _this$props8.colIndex,
        visibleRowIndex = _this$props8.visibleRowIndex;
      this.unsubscribeCell = this.context.onFocusUpdate([colIndex, visibleRowIndex], this.onFocusUpdate);

      // Account for virtualization - when a cell unmounts when scrolled out of view
      // and then remounts when scrolled back into view, it should retain focus state
      if (this.isFocusedCell()) {
        // The second flag sets preventScroll: true as a focus option, which prevents
        // hijacking the user's scroll behavior when the cell re-mounts on scroll
        this.onFocusUpdate(true, true);
        this.context.setIsFocusedCellInView(true);
      }

      // Check if popover should be open on mount (typically only occurs if
      // openCellPopover() is manually called on a location that's out of view)
      this.handleCellPopover();
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      if (this.unsubscribeCell) {
        this.unsubscribeCell();
      }
      if (this.isFocusedCell()) {
        this.context.setIsFocusedCellInView(false);
      }
      if (this.isPopoverOpen()) {
        this.props.popoverContext.closeCellPopover();
      }
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      var _this$props$rowHeight, _prevProps$rowHeights, _this$props$rowHeight2, _prevProps$rowHeights2, _this$props$rowHeight3, _prevProps$rowHeights3, _this$props$gridStyle, _prevProps$gridStyles, _this$props$gridStyle2, _prevProps$gridStyles2, _this$props$rowHeight4, _this$props$rowHeight5, _this$props$style, _prevProps$style;
      this.recalculateAutoHeight();
      if (((_this$props$rowHeight = this.props.rowHeightsOptions) === null || _this$props$rowHeight === void 0 ? void 0 : _this$props$rowHeight.defaultHeight) !== ((_prevProps$rowHeights = prevProps.rowHeightsOptions) === null || _prevProps$rowHeights === void 0 ? void 0 : _prevProps$rowHeights.defaultHeight) || ((_this$props$rowHeight2 = this.props.rowHeightsOptions) === null || _this$props$rowHeight2 === void 0 || (_this$props$rowHeight2 = _this$props$rowHeight2.rowHeights) === null || _this$props$rowHeight2 === void 0 ? void 0 : _this$props$rowHeight2[this.props.rowIndex]) !== ((_prevProps$rowHeights2 = prevProps.rowHeightsOptions) === null || _prevProps$rowHeights2 === void 0 || (_prevProps$rowHeights2 = _prevProps$rowHeights2.rowHeights) === null || _prevProps$rowHeights2 === void 0 ? void 0 : _prevProps$rowHeights2[prevProps.rowIndex]) || ((_this$props$rowHeight3 = this.props.rowHeightsOptions) === null || _this$props$rowHeight3 === void 0 ? void 0 : _this$props$rowHeight3.lineHeight) !== ((_prevProps$rowHeights3 = prevProps.rowHeightsOptions) === null || _prevProps$rowHeights3 === void 0 ? void 0 : _prevProps$rowHeights3.lineHeight) || ((_this$props$gridStyle = this.props.gridStyles) === null || _this$props$gridStyle === void 0 ? void 0 : _this$props$gridStyle.fontSize) !== ((_prevProps$gridStyles = prevProps.gridStyles) === null || _prevProps$gridStyles === void 0 ? void 0 : _prevProps$gridStyles.fontSize) || ((_this$props$gridStyle2 = this.props.gridStyles) === null || _this$props$gridStyle2 === void 0 ? void 0 : _this$props$gridStyle2.cellPadding) !== ((_prevProps$gridStyles2 = prevProps.gridStyles) === null || _prevProps$gridStyles2 === void 0 ? void 0 : _prevProps$gridStyles2.cellPadding)) {
        this.recalculateLineHeight();
      }
      if ((_this$props$rowHeight4 = this.props.rowHeightUtils) !== null && _this$props$rowHeight4 !== void 0 && _this$props$rowHeight4.compensateForLayoutShift && (_this$props$rowHeight5 = this.props.rowHeightsOptions) !== null && _this$props$rowHeight5 !== void 0 && _this$props$rowHeight5.scrollAnchorRow && this.props.colIndex === 0 &&
      // once per row
      this.props.columnId === prevProps.columnId &&
      // if this is still the same column
      this.props.rowIndex === prevProps.rowIndex &&
      // if this is still the same row
      ((_this$props$style = this.props.style) === null || _this$props$style === void 0 ? void 0 : _this$props$style.top) !== ((_prevProps$style = prevProps.style) === null || _prevProps$style === void 0 ? void 0 : _prevProps$style.top) // if the top position has changed
      ) {
        var _prevProps$style2, _this$props$style2, _this$props$rowHeight6;
        var previousTop = parseFloat((_prevProps$style2 = prevProps.style) === null || _prevProps$style2 === void 0 ? void 0 : _prevProps$style2.top);
        var currentTop = parseFloat((_this$props$style2 = this.props.style) === null || _this$props$style2 === void 0 ? void 0 : _this$props$style2.top);

        // @ts-ignore We've already checked that this virtualization util is available above
        this.props.rowHeightUtils.compensateForLayoutShift(this.props.rowIndex, currentTop - previousTop, (_this$props$rowHeight6 = this.props.rowHeightsOptions) === null || _this$props$rowHeight6 === void 0 ? void 0 : _this$props$rowHeight6.scrollAnchorRow);
      }
      if (this.props.popoverContext.popoverIsOpen !== prevProps.popoverContext.popoverIsOpen || this.props.popoverContext.cellLocation !== prevProps.popoverContext.cellLocation || this.props.renderCellPopover !== prevProps.renderCellPopover) {
        this.handleCellPopover();
      }
      if (this.props.columnId !== prevProps.columnId || this.props.rowIndex !== prevProps.rowIndex) {
        this.setCellProps({});
      }
    }
  }, {
    key: "shouldComponentUpdate",
    value: function shouldComponentUpdate(nextProps, nextState) {
      var _nextProps$gridStyles, _this$props$gridStyle3, _nextProps$gridStyles2, _this$props$gridStyle4;
      if (nextProps.rowIndex !== this.props.rowIndex) return true;
      if (nextProps.visibleRowIndex !== this.props.visibleRowIndex) return true;
      if (nextProps.colIndex !== this.props.colIndex) return true;
      if (nextProps.columnId !== this.props.columnId) return true;
      if (nextProps.columnType !== this.props.columnType) return true;
      if (nextProps.width !== this.props.width) return true;
      if (nextProps.rowHeightsOptions !== this.props.rowHeightsOptions) return true;
      if (((_nextProps$gridStyles = nextProps.gridStyles) === null || _nextProps$gridStyles === void 0 ? void 0 : _nextProps$gridStyles.fontSize) !== ((_this$props$gridStyle3 = this.props.gridStyles) === null || _this$props$gridStyle3 === void 0 ? void 0 : _this$props$gridStyle3.fontSize)) return true;
      if (((_nextProps$gridStyles2 = nextProps.gridStyles) === null || _nextProps$gridStyles2 === void 0 ? void 0 : _nextProps$gridStyles2.cellPadding) !== ((_this$props$gridStyle4 = this.props.gridStyles) === null || _this$props$gridStyle4 === void 0 ? void 0 : _this$props$gridStyle4.cellPadding)) return true;
      if (nextProps.renderCellValue !== this.props.renderCellValue) return true;
      if (nextProps.renderCellPopover !== this.props.renderCellPopover) return true;
      if (nextProps.interactiveCellId !== this.props.interactiveCellId) return true;
      if (nextProps.popoverContext.popoverIsOpen !== this.props.popoverContext.popoverIsOpen || nextProps.popoverContext.cellLocation !== this.props.popoverContext.cellLocation) return true;

      // respond to adjusted position & dimensions
      if (nextProps.style) {
        if (!this.props.style) return true;
        if (nextProps.style.top !== this.props.style.top) {
          return true;
        }
        if (nextProps.style.left !== this.props.style.left) return true;
        if (nextProps.style.height !== this.props.style.height) return true;
        if (nextProps.style.width !== this.props.style.width) return true;
      }
      if (nextProps.cellContext !== this.props.cellContext) return true;
      if (nextState.cellProps !== this.state.cellProps) return true;
      if (nextState.isFocused !== this.state.isFocused) return true;
      if (nextState.isHovered !== this.state.isHovered) return true;
      return false;
    }
  }, {
    key: "render",
    value: function render() {
      var _rowHeightsOptions$li;
      var _this$props9 = this.props,
        width = _this$props9.width,
        popoverContext = _this$props9.popoverContext,
        interactiveCellId = _this$props9.interactiveCellId,
        columnType = _this$props9.columnType,
        className = _this$props9.className,
        column = _this$props9.column,
        style = _this$props9.style,
        rowHeightUtils = _this$props9.rowHeightUtils,
        rowHeightsOptions = _this$props9.rowHeightsOptions,
        rowManager = _this$props9.rowManager,
        pagination = _this$props9.pagination,
        rest = (0, _objectWithoutProperties2.default)(_this$props9, _excluded2);
      var rowIndex = rest.rowIndex,
        visibleRowIndex = rest.visibleRowIndex,
        colIndex = rest.colIndex;
      var isExpandable = this.isExpandable();
      var popoverIsOpen = this.isPopoverOpen();
      var showCellActions = isExpandable && (popoverIsOpen || this.state.isFocused || this.state.isHovered);
      var cellClasses = (0, _classnames.default)('euiDataGridRowCell', (0, _defineProperty2.default)((0, _defineProperty2.default)({}, "euiDataGridRowCell--".concat(columnType), columnType), 'euiDataGridRowCell--open', popoverIsOpen), className);

      // classNames set by EuiDataGridCellWrapper
      var isControlColumn = cellClasses.includes('euiDataGridRowCell--controlColumn');
      var isLastColumn = cellClasses.includes('euiDataGridRowCell--lastColumn');
      var ariaRowIndex = pagination ? visibleRowIndex + 1 + pagination.pageSize * pagination.pageIndex : visibleRowIndex + 1;
      var _this$state$cellProps2 = this.state.cellProps,
        _ = _this$state$cellProps2.isExpandable,
        cellPropsStyle = _this$state$cellProps2.style,
        cellPropsClassName = _this$state$cellProps2.className,
        cellPropsDataTestSubj = _this$state$cellProps2['data-test-subj'],
        setCellProps = (0, _objectWithoutProperties2.default)(_this$state$cellProps2, _excluded3);
      var cellProps = _objectSpread(_objectSpread({}, setCellProps), {}, {
        'data-test-subj': (0, _classnames.default)('dataGridRowCell', cellPropsDataTestSubj),
        className: (0, _classnames.default)(cellClasses, cellPropsClassName)
      });
      cellProps.style = _objectSpread(_objectSpread({}, style), {}, {
        // set by react-window or the custom renderer
        top: style !== null && style !== void 0 && style.top ? 0 : undefined,
        // The cell's row will handle top positioning
        width: width,
        // column width, can be undefined
        lineHeight: (_rowHeightsOptions$li = rowHeightsOptions === null || rowHeightsOptions === void 0 ? void 0 : rowHeightsOptions.lineHeight) !== null && _rowHeightsOptions$li !== void 0 ? _rowHeightsOptions$li : undefined
      }, cellPropsStyle);
      var row = rowManager && !_utils.IS_JEST_ENVIRONMENT ? rowManager.getRow({
        rowIndex: rowIndex,
        visibleRowIndex: visibleRowIndex,
        top: style.top,
        // comes in as a `{float}px` string from react-window
        height: style.height // comes in as an integer from react-window
      }) : undefined;
      return (0, _react2.jsx)(RenderCellInRow, {
        row: row
      }, (0, _react2.jsx)(GridCellDiv, (0, _extends2.default)({}, cellProps, {
        ref: this.cellRef,
        columnId: this.props.columnId,
        columnIndex: this.props.colIndex,
        rowIndex: rowIndex,
        visibleRowIndex: this.props.visibleRowIndex,
        "aria-rowindex": ariaRowIndex,
        tabIndex: this.state.isFocused ? 0 : -1,
        onKeyDown: this.handleCellKeyDown,
        onMouseEnter: this.onMouseEnter,
        onMouseLeave: this.onMouseLeave
      }), (0, _react2.jsx)(_focus_utils.HandleInteractiveChildren, {
        cellEl: this.cellRef.current,
        updateCellFocusContext: this.updateCellFocusContext,
        renderFocusTrap: !isExpandable
      }, (0, _react2.jsx)(EuiDataGridCellContent, (0, _extends2.default)({}, rest, {
        setCellProps: this.setCellProps,
        column: column,
        columnType: columnType,
        isExpandable: isExpandable,
        isExpanded: popoverIsOpen,
        setCellContentsRef: this.setCellContentsRef,
        rowHeightsOptions: rowHeightsOptions,
        rowHeightUtils: rowHeightUtils,
        isControlColumn: isControlColumn,
        rowIndex: rowIndex,
        colIndex: colIndex
      }))), isLastColumn ? _services.tabularCopyMarkers.hiddenNewline : _services.tabularCopyMarkers.hiddenTab, this.state.isFocused && (0, _react2.jsx)(CellScreenReaderDescription, {
        columnName: (column === null || column === void 0 ? void 0 : column.displayAsText) || this.props.columnId,
        columnIndex: colIndex + 1,
        rowIndex: ariaRowIndex,
        canExpandCell: showCellActions
      }), showCellActions && (0, _react2.jsx)(_data_grid_cell_actions.EuiDataGridCellActions, {
        rowIndex: rowIndex,
        colIndex: colIndex,
        column: column,
        onExpandClick: this.handleCellExpansionClick,
        popoverAnchorRef: this.popoverAnchorRef
      })));
    }
  }]);
}(_react.Component);
/**
 * Function component utilities for conditional rendering.
 * Used for DRYness and performance
 */
(0, _defineProperty2.default)(EuiDataGridCell, "contextType", _focus.DataGridFocusContext);
var RenderCellInRow = /*#__PURE__*/(0, _react.memo)(function (_ref2) {
  var row = _ref2.row,
    children = _ref2.children;
  return row ? /*#__PURE__*/(0, _reactDom.createPortal)(children, row) : children;
});
RenderCellInRow.displayName = 'RenderCellInRow';
var RenderTruncatedCellContent = /*#__PURE__*/(0, _react.memo)(function (_ref3) {
  var children = _ref3.children,
    hasLineCountTruncation = _ref3.hasLineCountTruncation,
    rowHeight = _ref3.rowHeight;
  // If `hasLineCountTruncation` is true, we can rely on rowHeight being the correct type
  var lines = hasLineCountTruncation ? rowHeight.lineCount : undefined;
  return lines ? (0, _react2.jsx)(_text_truncate.EuiTextBlockTruncate, {
    lines: lines,
    cloneElement: true
  }, children) : children;
});
RenderTruncatedCellContent.displayName = 'RenderTruncatedCellContent';

/**
 * Function component utilities for easier hook usage
 */

var GridCellDiv = /*#__PURE__*/(0, _react.memo)( /*#__PURE__*/(0, _react.forwardRef)(function (_ref4, ref) {
  var columnId = _ref4.columnId,
    columnIndex = _ref4.columnIndex,
    rowIndex = _ref4.rowIndex,
    visibleRowIndex = _ref4.visibleRowIndex,
    props = (0, _objectWithoutProperties2.default)(_ref4, _excluded4);
  var styles = (0, _services.useEuiMemoizedStyles)(_data_grid_cell.euiDataGridRowCellStyles);
  return (0, _react2.jsx)("div", (0, _extends2.default)({
    ref: ref,
    css: styles.euiDataGridRowCell
  }, props, {
    role: "gridcell"
    // Data attributes to help target specific cells by either data or current cell location
    ,
    "data-gridcell-column-id": columnId // Static column ID name, not affected by column order
    ,
    "data-gridcell-column-index": columnIndex // Affected by column reordering
    ,
    "data-gridcell-row-index": rowIndex // Index from data, not affected by sorting or pagination
    ,
    "data-gridcell-visible-row-index": visibleRowIndex // Affected by sorting & pagination
  }));
}));
GridCellDiv.displayName = 'GridCellDiv';
var CellScreenReaderDescription = /*#__PURE__*/(0, _react.memo)(function (_ref5) {
  var columnName = _ref5.columnName,
    columnIndex = _ref5.columnIndex,
    rowIndex = _ref5.rowIndex,
    canExpandCell = _ref5.canExpandCell;
  var cellPosition = (0, _i18n.useEuiI18n)('euiDataGridCell.position', '{columnName}, column {columnIndex}, row {rowIndex}', {
    columnName: columnName,
    columnIndex: columnIndex,
    rowIndex: rowIndex
  });
  var enterKeyPrompt = (0, _i18n.useEuiI18n)('euiDataGridCell.expansionEnterPrompt', 'Press the Enter key to expand this cell.');
  return (0, _react2.jsx)(_accessibility.EuiScreenReaderOnly, null, (0, _react2.jsx)("p", null, _services.tabularCopyMarkers.hiddenNoCopyBoundary, " - ".concat(cellPosition).concat(canExpandCell ? ". ".concat(enterKeyPrompt) : ''), _services.tabularCopyMarkers.hiddenNoCopyBoundary));
});
CellScreenReaderDescription.displayName = 'CellScreenReaderDescription';