"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiDataGridCellPopoverActions = exports.EuiDataGridCellActions = void 0;
var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _services = require("../../../../services");
var _i18n = require("../../../i18n");
var _button_icon = require("../../../button/button_icon");
var _button_empty = require("../../../button/button_empty");
var _flex = require("../../../flex");
var _popover = require("../../../popover");
var _data_grid_cell_actions = require("./data_grid_cell_actions.styles");
var _react2 = require("@emotion/react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var EuiDataGridCellActions = exports.EuiDataGridCellActions = function EuiDataGridCellActions(_ref) {
  var onExpandClick = _ref.onExpandClick,
    popoverAnchorRef = _ref.popoverAnchorRef,
    column = _ref.column,
    rowIndex = _ref.rowIndex,
    colIndex = _ref.colIndex;
  var styles = (0, _services.useEuiMemoizedStyles)(_data_grid_cell_actions.euiDataGridCellActionsStyles);

  // Note: The cell expand button/expansion popover is *always* rendered if
  // column.cellActions is present (regardless of column.isExpandable).
  // This is because cell actions are not otherwise accessible to keyboard
  // or screen reader users
  var expandButton = (0, _react.useMemo)(function () {
    return (0, _react2.jsx)(_i18n.EuiI18n, {
      key: 'expand',
      token: "euiDataGridCellActions.expandButtonTitle",
      default: "Click or hit enter to interact with cell content"
    }, function (expandButtonTitle) {
      return (0, _react2.jsx)(_button_icon.EuiButtonIcon, {
        css: styles.euiDataGridRowCell__actionButtonIcon,
        className: "euiDataGridRowCell__actionButtonIcon euiDataGridRowCell__expandCell",
        "data-test-subj": "euiDataGridCellExpandButton",
        display: "fill",
        color: "primary",
        iconSize: "m",
        iconType: "expandMini",
        "aria-hidden": true,
        onClick: onExpandClick,
        title: expandButtonTitle
      });
    });
  }, [onExpandClick, styles]);
  var additionalButtons = (0, _react.useMemo)(function () {
    if (!column || !Array.isArray(column === null || column === void 0 ? void 0 : column.cellActions)) return [];
    var ButtonComponent = function ButtonComponent(props) {
      return (0, _react2.jsx)(_button_icon.EuiButtonIcon, (0, _extends2.default)({}, props, {
        "aria-hidden": true,
        css: styles.euiDataGridRowCell__actionButtonIcon,
        className: "euiDataGridRowCell__actionButtonIcon"
        // Don't allow consumers to override sizes or colors for cell actions on hover/focus
        ,
        size: "xs",
        iconSize: "s",
        display: "fill",
        color: "primary"
      }));
    };
    var _getVisibleCellAction = getVisibleCellActions(column === null || column === void 0 ? void 0 : column.cellActions, column === null || column === void 0 ? void 0 : column.visibleCellActions),
      _getVisibleCellAction2 = (0, _slicedToArray2.default)(_getVisibleCellAction, 1),
      visibleCellActions = _getVisibleCellAction2[0];
    return visibleCellActions.map(function (Action, idx) {
      // React is more permissible than the TS types indicate
      var ActionButtonElement = Action;
      return (0, _react2.jsx)(ActionButtonElement, {
        key: idx,
        rowIndex: rowIndex,
        colIndex: colIndex,
        columnId: column.id,
        Component: ButtonComponent,
        isExpanded: false
      });
    });
  }, [column, colIndex, rowIndex, styles]);
  return (0, _react2.jsx)("div", {
    css: styles.euiDataGridRowCell__actionsWrapper,
    className: "euiDataGridRowCell__actionsWrapper"
  }, (0, _react2.jsx)("div", {
    css: styles.euiDataGridRowCell__actions,
    className: "euiDataGridRowCell__actions"
  }, [].concat((0, _toConsumableArray2.default)(additionalButtons), [expandButton])), (0, _react2.jsx)("div", {
    ref: popoverAnchorRef,
    "data-test-subject": "cellPopoverAnchor"
  }));
};
var EuiDataGridCellPopoverActions = exports.EuiDataGridCellPopoverActions = function EuiDataGridCellPopoverActions(_ref2) {
  var rowIndex = _ref2.rowIndex,
    colIndex = _ref2.colIndex,
    column = _ref2.column;
  var _getVisibleCellAction3 = getVisibleCellActions(column === null || column === void 0 ? void 0 : column.cellActions, column === null || column === void 0 ? void 0 : column.visibleCellActions),
    _getVisibleCellAction4 = (0, _slicedToArray2.default)(_getVisibleCellAction3, 2),
    primaryActions = _getVisibleCellAction4[0],
    secondaryActions = _getVisibleCellAction4[1];
  var renderActions = (0, _react.useCallback)(function (Action, idx) {
    var ActionButtonElement = Action;
    return (0, _react2.jsx)(_flex.EuiFlexItem, {
      key: idx
    }, (0, _react2.jsx)("div", null, (0, _react2.jsx)(ActionButtonElement, {
      rowIndex: rowIndex,
      colIndex: colIndex,
      columnId: column.id,
      Component: function Component(props) {
        return (0, _react2.jsx)(_button_empty.EuiButtonEmpty, (0, _extends2.default)({}, props, {
          size: "s"
        }));
      },
      isExpanded: true
    })));
  }, [column, colIndex, rowIndex]);
  return (0, _react2.jsx)(_react.default.Fragment, null, primaryActions.length > 0 && (0, _react2.jsx)(_popover.EuiPopoverFooter, null, (0, _react2.jsx)(_flex.EuiFlexGroup, {
    gutterSize: "s",
    responsive: false,
    wrap: true
  }, primaryActions.map(renderActions))), secondaryActions.length > 0 && (0, _react2.jsx)(_popover.EuiPopoverFooter, null, (0, _react2.jsx)(_flex.EuiFlexGroup, {
    gutterSize: "s",
    direction: "column",
    alignItems: "flexStart"
  }, secondaryActions.map(renderActions))));
};

// Util helper to separate primary actions (columns.visibleCellActions, defaults to 2)
// and secondary actions (all remaning actions)
var getVisibleCellActions = function getVisibleCellActions(cellActions) {
  var visibleCellActions = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 2;
  if (!cellActions) return [[], []];
  if (cellActions.length <= visibleCellActions) return [cellActions, []];
  var primaryCellActions = cellActions.slice(0, visibleCellActions);
  var remainingCellActions = cellActions.slice(visibleCellActions);
  return [primaryCellActions, remainingCellActions];
};