"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HandleInteractiveChildren = exports.FocusTrappedChildren = void 0;
var _toArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toArray"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _react = _interopRequireWildcard(require("react"));
var _tabbable = require("tabbable");
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../../../services");
var _utils = require("../../../../utils");
var _focus_trap = require("../../../focus_trap");
var _i18n = require("../../../i18n");
var _react2 = require("@emotion/react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * This internal utility component is used by all cells, both header and body/footer cells.
 * It always handles:
 *   1. Removing any interactive children from keyboard tab order on cell mount
 *   2. Listening for focus on any interactive children and updating the cell focus context
 *
 * It should *only* render focus traps for:
 *   1. Header cells that are `actions: false` but still have interactive children
 *   2. Body cells that are `isExpandable: false` but still have interactive children
 */
var HandleInteractiveChildren = exports.HandleInteractiveChildren = function HandleInteractiveChildren(_ref) {
  var cellEl = _ref.cellEl,
    children = _ref.children,
    updateCellFocusContext = _ref.updateCellFocusContext,
    renderFocusTrap = _ref.renderFocusTrap,
    onInteractiveChildrenFound = _ref.onInteractiveChildrenFound;
  var _useState = (0, _react.useState)(false),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    hasInteractiveChildren = _useState2[0],
    setHasInteractiveChildren = _useState2[1];

  // On mount, disable all interactive children
  (0, _react.useEffect)(function () {
    if (cellEl) {
      var interactives = disableInteractives(cellEl);
      onInteractiveChildrenFound === null || onInteractiveChildrenFound === void 0 || onInteractiveChildrenFound(interactives);
      setHasInteractiveChildren(interactives.length > 0);
    }
  }, [cellEl, onInteractiveChildrenFound]);

  // Ensure that any interactive children that are clicked update the latest cell focus context
  (0, _react.useEffect)(function () {
    if (cellEl) {
      var onFocus = function onFocus() {
        return updateCellFocusContext();
      };
      cellEl.addEventListener('focus', onFocus, true); // useCapture listens for focus on children
      return function () {
        cellEl.removeEventListener('focus', onFocus, true);
      };
    }
  }, [cellEl, updateCellFocusContext]);
  var _children = (0, _react.useMemo)(function () {
    return (0, _react2.jsx)(_react.default.Fragment, null, children);
  }, [children]);
  if (!cellEl) return _children; // Do nothing if cell has yet to mount or is unmounting
  if (!renderFocusTrap) return _children; // Cells with default actions / expansion popovers do not need to trap
  if (!hasInteractiveChildren) return _children; // No need to focus trap if no children are interactive

  return (0, _react2.jsx)(FocusTrappedChildren, {
    cellEl: cellEl
  }, children);
};

/**
 * Cells with interactive children but no cell popover expansion should render a
 * focus trap that can be entered with the Enter key, which cycles keyboard tabs
 * through the cell contents only, and exited with the Escape key
 */
var FocusTrappedChildren = exports.FocusTrappedChildren = function FocusTrappedChildren(_ref2) {
  var cellEl = _ref2.cellEl,
    children = _ref2.children;
  var _useState3 = (0, _react.useState)(false),
    _useState4 = (0, _slicedToArray2.default)(_useState3, 2),
    isCellEntered = _useState4[0],
    setIsCellEntered = _useState4[1];
  var _useState5 = (0, _react.useState)(false),
    _useState6 = (0, _slicedToArray2.default)(_useState5, 2),
    isExited = _useState6[0],
    setExited = _useState6[1];
  var ariaDescribedById = (0, _services.useGeneratedHtmlId)({
    suffix: 'focusTrapHint'
  });

  // direct DOM manipulation as workaround to attach required hints
  (0, _react.useEffect)(function () {
    var _currentAriaDescribed;
    var currentAriaDescribedbyId = cellEl.getAttribute('aria-describedby');
    // A11y: splitting ids to be able to append the first hint (sorting)
    // while other hints should follow the keyboard navigation hints
    var _ref3 = (_currentAriaDescribed = currentAriaDescribedbyId === null || currentAriaDescribedbyId === void 0 ? void 0 : currentAriaDescribedbyId.split(' ')) !== null && _currentAriaDescribed !== void 0 ? _currentAriaDescribed : [],
      _ref4 = (0, _toArray2.default)(_ref3),
      sortingId = _ref4[0],
      rest = _ref4.slice(1);
    var remainingIds = rest.join(' ');
    cellEl.setAttribute('aria-describedby', (0, _classnames.default)(sortingId, ariaDescribedById, !isCellEntered && remainingIds));
    return function () {
      if (currentAriaDescribedbyId) {
        cellEl.setAttribute('aria-describedby', currentAriaDescribedbyId);
      } else {
        cellEl.removeAttribute('aria-describedby');
      }
    };
  }, [cellEl, ariaDescribedById, isCellEntered]);
  (0, _react.useEffect)(function () {
    if (isCellEntered) {
      enableAndFocusInteractives(cellEl);
    } else {
      disableInteractives(cellEl);
    }
  }, [isCellEntered, cellEl]);
  (0, _react.useEffect)(function () {
    var onKeyUp = function onKeyUp(event) {
      switch (event.key) {
        case _services.keys.ENTER:
        case _services.keys.F2:
          event.preventDefault();
          setIsCellEntered(true);
          break;
        case _services.keys.ESCAPE:
          event.preventDefault();
          setIsCellEntered(function (isCellEntered) {
            if (isCellEntered === true) {
              setExited(true);
              requestAnimationFrame(function () {
                return cellEl.focus();
              }); // move focus to cell
              return false;
            } else if (
            // when opened content is closed, we don't want Escape to return to the cell
            // immediately but instead return focus to a trigger as expected
            isCellEntered === false && (0, _utils.isDOMNode)(event.target) && (0, _utils.isDOMNode)(event.currentTarget) && event.currentTarget !== event.target && event.currentTarget.contains(event.target)) {
              return true;
            }
            return isCellEntered;
          });
          break;
      }
    };

    // ensures the SR text is reset when navigating to a different cell
    var onBlur = function onBlur() {
      return setExited(false);
    };
    cellEl.addEventListener('keyup', onKeyUp);
    cellEl.addEventListener('blur', onBlur);
    return function () {
      cellEl.removeEventListener('keyup', onKeyUp);
      cellEl.removeEventListener('blur', onBlur);
    };
  }, [cellEl]);
  return (0, _react2.jsx)(_focus_trap.EuiFocusTrap, {
    disabled: !isCellEntered,
    clickOutsideDisables: true,
    onDeactivation: function onDeactivation() {
      return setIsCellEntered(false);
    }
  }, children, (0, _react2.jsx)("p", {
    id: ariaDescribedById,
    hidden: true
  }, isExited && (0, _react2.jsx)(_i18n.EuiI18n
  // eslint-disable-next-line local/i18n
  , {
    token: "euiDataGridCell.focusTrapExitPrompt",
    default: "Exited cell content."
  }), !isCellEntered && (0, _react2.jsx)(_i18n.EuiI18n
  // eslint-disable-next-line local/i18n
  , {
    token: "euiDataGridCell.focusTrapEnterPrompt",
    default: "Press the Enter key to interact with this cell's contents."
  })));
};

/**
 * Utility fns for managing child interactive tabIndex state
 */

var disableInteractives = function disableInteractives(cell) {
  var interactives = (0, _tabbable.tabbable)(cell);
  interactives.forEach(function (element) {
    element.setAttribute('data-euigrid-tab-managed', 'true');
    element.setAttribute('tabIndex', '-1');
  });
  return interactives;
};
var enableAndFocusInteractives = function enableAndFocusInteractives(cell) {
  var interactives = cell.querySelectorAll('[data-euigrid-tab-managed]');
  interactives.forEach(function (element, i) {
    element.setAttribute('tabIndex', '0');
    // focus the first element only if we're on the cell and not inside of it
    if (i === 0 && !cell.contains(document.activeElement)) {
      element.focus();
    }
  });
  return interactives;
};