"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiDataGridBody = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireDefault(require("react"));
var _services = require("../../../services");
var _data_grid_body_virtualized = require("./data_grid_body_virtualized");
var _data_grid_body_custom = require("./data_grid_body_custom");
var _data_grid_body = require("./data_grid_body.styles");
var _react2 = require("@emotion/react");
var _excluded = ["renderCustomGridBody"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var EuiDataGridBody = exports.EuiDataGridBody = function EuiDataGridBody(_ref) {
  var renderCustomGridBody = _ref.renderCustomGridBody,
    props = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  /*
   * Determine whether we should use the default EuiDataGridBody
   * + virtualization library for rendering content, or if consumers have
   * passed their own custom renderer
   */
  var styles = (0, _services.useEuiMemoizedStyles)(_data_grid_body.euiDataGridBodyStyles);
  var cssStyles = [styles.euiDataGridBody, renderCustomGridBody ? styles.customRender : styles.virtualized];
  return renderCustomGridBody ? (0, _react2.jsx)(_data_grid_body_custom.EuiDataGridBodyCustomRender, (0, _extends2.default)({
    renderCustomGridBody: renderCustomGridBody,
    css: cssStyles
  }, props)) : (0, _react2.jsx)(_data_grid_body_virtualized.EuiDataGridBodyVirtualized, (0, _extends2.default)({
    css: cssStyles
  }, props));
};